/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.transform;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.BaseReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.ClusterReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.InstanceReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.WebModuleReader;
import org.jvnet.glassfish.comms.clb.admin.Cluster;
import org.jvnet.glassfish.comms.clb.admin.Instance;
import org.jvnet.glassfish.comms.clb.admin.WebModule;


/**
 * Provides transform capabilites for cluster
 *
 * @author Vijaya Gadhamsetty
 */
public class ClusterVisitor implements Visitor {
    //--- PRIVATE VARS ----
    Cluster _c = null;

    // ------ CTOR ------
    public ClusterVisitor(Cluster c) {
        _c = c;
    }

    /**
     * Visit reader class
     */
    public void visit(BaseReader br) {
        // FIXME, make as assert here about no class cast exception
        ClusterReader cRdr = (ClusterReader) br;

        try {
            _c.setName(cRdr.getName());
            _c.setSelfLoadbalance(cRdr.getSelfLoadbalance());
        } catch (LbReaderException le) {
            // XXX ignore
        }

        InstanceReader[] iRdrs = null;

        try {
            iRdrs = cRdr.getInstances();
        } catch (LbReaderException le) {
            // should we throw this exception XXX ???
            // or fill in with default values
        }

        if ((iRdrs != null) && (iRdrs.length > 0)) {
            Instance ins = null;

            for (int i = 0; i < iRdrs.length; i++) {
                ins = new Instance();
                iRdrs[i].accept(new InstanceVisitor(ins));
                _c.addInstance(ins);
            }
        }

        WebModuleReader[] wRdrs = null;

        try {
            wRdrs = cRdr.getWebModules();
        } catch (LbReaderException le) {
            // XXX ignore
        }

        if ((wRdrs != null) && (wRdrs.length > 0)) {
            WebModule wMod = null;

            for (int i = 0; i < wRdrs.length; i++) {
                wMod = new WebModule();
                wRdrs[i].accept(new WebModuleVisitor(wMod));
                _c.addWebmodule(wMod);
            }
        }
    }
}
