/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.admin.cli.extensions.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.enterprise.cli.commands.GenericCommand;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;


/* This class validates the options for the Converged Load Balancer
 * and throws an error if config name as well as any other option to
 * create the config is given
 */ 

public class CreateConvergedLbCommand extends GenericCommand
{
    private static final String SELFLB_OPTION = "selfloadbalance";
    private static final String LBENABLE_OPTION = "lbenableallinstances";
    private static final String CLBCONFIG_OPTION = "clbconfig";
    private static final String DCRFILE_OPTION = "dcrfile";
    private static final String HTTPLB_OPTION = "httplbpolicy";
    private static final String SIPLB_OPTION = "siplbpolicy";
    private static final String LBTARGET_OPTION = "lbtarget";


    public void runCommand() throws CommandException, CommandValidationException
    {
        if (!validateOptions())
	{
	  throw new CommandException(getLocalizedString("InvalidClbCommand"));
        }
        //use http connector
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(),
                                                              getUser(), getPassword());
        final String objectName = getObjectName();
        final Object[] params = getParamsInfo();
        final String operationName = getOperationName();
        final String[] types = getTypesInfo();

        try
        {
            Object returnValue = mbsc.invoke(new ObjectName(objectName),
                                             operationName, params, types);
            handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "CommandSuccessful",
                                                       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }
     }

    public boolean validateOptions() throws CommandValidationException
    {
        super.validateOptions();
        final String selfLoadBalance= getCLOption(SELFLB_OPTION);
        final String lbEnableAllInstances= getCLOption(LBENABLE_OPTION);
        final String clbConfig= getCLOption(CLBCONFIG_OPTION);
        final String dcrFileName= getCLOption(DCRFILE_OPTION);
        final String httplbPolicy= getCLOption(HTTPLB_OPTION);
        final String siplbPolicy= getCLOption(SIPLB_OPTION);
        final String lbtargetName= getCLOption(LBTARGET_OPTION);
        
	if(clbConfig != null && (dcrFileName != null || httplbPolicy != null || siplbPolicy != null || lbtargetName != null || selfLoadBalance != null || lbEnableAllInstances != null))
        {
           return false;                                        
        }
        return true;
    }
}
