/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.admin.cli.extensions.commands;

import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.commands.CreateDomainCommand;

import com.sun.enterprise.admin.servermgmt.DomainConfig;

import java.util.Properties;

public class CreateSIPDomainCommand extends CreateDomainCommand
{
    // constant variables for create-domain options
    public static final String K_SIP_PORT      = "sip.port";
    public static final String K_SIP_SSL_PORT  = "sip.ssl.port";

    private static final int DEFAULT_SIP_PORT          = 5060;
    private static final int DEFAULT_SIP_SSL_PORT      = 5061;

    private static final int PORTBASE_SIP_SUFFIX          = 60;
    private static final int PORTBASE_SIPSSL_SUFFIX          = 61;

    /** Creates new CreateSIPDomainCommand */
    public CreateSIPDomainCommand()
    {
    }

    private void setOptionsWithSIPPortBase(final int portbase) throws CommandValidationException
    {
        String props = getOption(DOMAIN_PROPERTIES);
        StringBuffer sb = new StringBuffer();

        sb.append(props);

        verifyPortBasePortIsValid(K_SIP_PORT, portbase+PORTBASE_SIP_SUFFIX);        
        sb.append(":");
        sb.append(K_SIP_PORT);
        sb.append("=");
        sb.append(String.valueOf(portbase+PORTBASE_SIP_SUFFIX));
        sb.append(":");

        verifyPortBasePortIsValid(K_SIP_SSL_PORT, portbase+PORTBASE_SIPSSL_SUFFIX);        
        sb.append(":");
        sb.append(K_SIP_SSL_PORT);
        sb.append("=");
        sb.append(String.valueOf(portbase+PORTBASE_SIPSSL_SUFFIX));
        setOption(DOMAIN_PROPERTIES, sb.toString());
    }
    
    /**
     *  An abstract method that executes the command
     *  @throws CommandException
     */
    public void runCommand() 
        throws CommandException, CommandValidationException
    {
        validateDomain();

        verifyPortBase();

        if (getOption(PORTBASE_OPTION) != null) {
            final int portbase = convertPortStr(getOption(PORTBASE_OPTION));
            setOptionsWithSIPPortBase(portbase);
        }

        getAndValidatePasswords();
    
        try
        {
            //get domain properties from options or from option
            Properties domainProperties = getDomainProperties(getOption(DOMAIN_PROPERTIES));
            //we give priority to the --adminport option
            domainProperties.remove(DomainConfig.K_ADMIN_PORT);
            //saving the login information happens inside this method
            createTheDomain(getDomainsRoot(), domainProperties);
        }
        catch (Exception e)
        {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(getLocalizedString("CouldNotCreateDomain",
                new Object[] {domainName}), e);
        }
    }

    /** 
     *  create the domain
     *  @param domainPath - domain path to insert in domainConfig
     *  @param domainProperties - properties to insert in domainConfig
     *  @throws CommandException if domain cannot be created
     */
    private void createTheDomain(final String domainPath,
                                 Properties domainProperties)
        throws Exception
    {
        initDomain(domainPath, domainProperties);

        final Integer sipPort = getPort(domainProperties,
                                             K_SIP_PORT,
                                             null,
                                             Integer.toString(DEFAULT_SIP_PORT),
                                             "SIP Instance");

        final Integer sipSSLPort = getPort(domainProperties,
                                            K_SIP_SSL_PORT, null, 
                                            Integer.toString(DEFAULT_SIP_SSL_PORT), 
                                            "SIP_SSL");
        checkPortPrivilege(new Integer[]{sipPort, sipSSLPort});
        
        DomainConfig domainConfig = getDomainConfigInstance();

        // all tokens that are not pre-defined (PEDomainXmlTokens) are read as strings
        domainConfig.put(K_SIP_PORT, sipPort.toString());
        domainConfig.put(K_SIP_SSL_PORT, sipSSLPort.toString());

        create(domainConfig);
    }
}
