/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.admin.cli.extensions.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.enterprise.cli.commands.*;
import com.sun.enterprise.admin.common.JMXFileTransfer;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.util.SystemPropertyConstants;
import javax.management.ObjectName;
import java.util.Vector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DCRCommand extends S1ASCommand
{
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        
        try { 
            // upload the dcr file to the das config directory
            MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                                  getUser(), getPassword());
            String remoteLocation = uploadFileToServer(mbsc);
            CLILogger.getInstance().printDebugMessage("uploadedFile = " + 
                                            remoteLocation);
            
            // update the converged-lb-policy element with dcrfile attribute
            String objectName = getObjectName();
            Object[] params = getParamsInfo();
            String operationName = getOperationName();
            String[] types = getTypesInfo();

            Object returnValue = mbsc.invoke(new ObjectName(objectName), 
                                             operationName, params, types);
            handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "CommandSuccessful", new Object[] {name}));
        } catch(Exception e) {
            displayExceptionMessage(e);
        }
    }

    /**
     *Uploads file to temp location on server.
     *@throws CommandException
     */
    private String uploadFileToServer(MBeanServerConnection mbsc) 
                        throws CommandException, IOException
    {
        Vector operands = getOperands();
        String dcrFileLocation = (String) operands.get(0);
        File file = new File(dcrFileLocation);
        if (!file.exists()) {
            String msg = getLocalizedString("InvalidDcrFile");
            throw new CommandException(msg);
        } else if (file.isDirectory()) {
            String msg = getLocalizedString("DcrFileIsDirectory");
            throw new CommandException(msg);
        } else if (file.length() == 0) {
            String msg = getLocalizedString("EmptyDcrFile");
            throw new CommandException(msg);
        } 
        try {
            validateDCR(file);
        } catch (Exception e) {
            String msg = getLocalizedString("InvalidDcrDTDCheck");
            throw new CommandException(msg + " " + e.getMessage());
        }

        return new JMXFileTransfer(mbsc).uploadFile(dcrFileLocation, "config");
    }
    
    private void validateDCR(File dcrFile) throws Exception {
        FileInputStream in = new FileInputStream(dcrFile);
        
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler());
        db.setEntityResolver(new ErrorHandler());
        
        Document doc = db.parse(in);
    }
    
    class ErrorHandler extends DefaultHandler {

        public InputSource resolveEntity(String publicId, String systemId)
            throws SAXException, IOException {

            final String DCR_DTD_FILE = "lib" + File.separator + "dtds" +
                                File.separator + "sun-data-centric-rule_1_0.dtd";

            String installDir = System.getProperty(SystemPropertyConstants.INSTALL_ROOT_PROPERTY);
            String customSystemId = installDir + File.separator + DCR_DTD_FILE;
            InputSource is = new InputSource(new FileInputStream(new File(customSystemId)));
            return is;
        }
        
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(e.getMessage());
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(e.getMessage());
        }

    }
}