/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.event.extensions.sip;

import com.sun.enterprise.admin.event.ElementChangeEvent;

/**
 * <pre>
 *      An event related to changes to the principal element
 *      in domain.xml.
 * </pre>
 *
 */
public class PrincipalEvent extends ElementChangeEvent {
    /**
     * Event type
     */
    public static final String eventType = PrincipalEvent.class.getName();

    /**
     * Create a new PrincipalEvent.
     *
     * @param instance name of the instance to which the event applies
     * @param action type of action - one of
     *              ElementChangeEvent.ACTION_ELEMENT_*
     *
     * @throws IllegalArgumentException if specified action is not valid
     */
    public PrincipalEvent(String instance, int action, String name) {
        super(instance, PrincipalEvent.eventType, action, name);
    }
}
