/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */


package org.jvnet.glassfish.comms.admin.gui.extensions.handlers;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.annotation.Handler;
import com.sun.jsftemplating.annotation.HandlerInput;
import com.sun.jsftemplating.annotation.HandlerOutput;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.jvnet.glassfish.comms.admin.gui.extensions.util.SipSecurityHelper;
import org.jvnet.glassfish.comms.admin.gui.extensions.util.SipUtil;

/**
 *
 * @author irfan@sun.com
 */
public class SecurityHandlers {
    
    @Handler(id="getTrustedConfigsList",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="result", type=List.class)
    })
    public static void getTrustedConfigsList(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        ArrayList result = new ArrayList();
        try {
            List<ObjectName> trustConfigs = SipSecurityHelper.getTrustConfigs(configName);
            for (ObjectName trustConfig : trustConfigs) {
                String name = trustConfig.getKeyProperty("id");
                String trustConfigType = SipSecurityHelper.getTrustConfigType(trustConfig);
                HashMap oneRow = new HashMap();
                oneRow.put("name", name);
                oneRow.put("type", trustConfigType);
                oneRow.put("selected", false);
		String[] attributeList = (String[]) SipSecurityHelper.getTrustConfigAttributes().toArray(
			new String[SipSecurityHelper.getTrustConfigAttributes().size()]);
		HashMap attributes = SipUtil.getAttributeValues(trustConfig, attributeList, true);
		oneRow.putAll(attributes);
                result.add(oneRow);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("result", result);
    }
    
    @Handler(id="intializeTrustConfig",
    input={
        @HandlerInput(name="configName", type=String.class)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class)
    })
    public static void intializeTrustConfig(HandlerContext handlerContext) {
        HashMap map = new HashMap();
        map.put("trustTypeOption", "entity");
        map.put("default", false);
        handlerContext.setOutputValue("attrMap", map);
    }
    
    @Handler(id="createTrustConfig",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="trustTypeOption", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class, required=true),
        @HandlerInput(name="handlerProps", type=Map.class, required=true)
    })
    public static void createTrustConfig(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        try {
            attrMap.put("trustTypeOption", (String) handlerContext.getInputValue("trustTypeOption"));
            attrMap.put("handlerProps", (HashMap) handlerContext.getInputValue("handlerProps"));
            SipSecurityHelper.createTrustConfig(configName, attrMap);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="deleteTrustConfig",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="selectedRows", type=List.class)
    })
    public static void deleteTrustConfig(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        List<Map> rows = (List) handlerContext.getInputValue("selectedRows");
        try {
            for (Map oneRow : rows) {
                String id = (String) oneRow.get("name");
                SipSecurityHelper.deleteTrustConfig(configName, id);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
            
    }
    
    @Handler(id="getTrustConfigInfo",
    input={
	@HandlerInput(name="name", type=String.class, required=true),
	@HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
	@HandlerOutput(name="attrMap", type=HashMap.class),
	@HandlerOutput(name="HandlerProps", type=Map.class),
	@HandlerOutput(name="HandlerEntities", type=List.class)
    })
    public static void getTrustConfigInfo(HandlerContext handlerContext) {
	String configName = (String) handlerContext.getInputValue("configName");
	String name = (String) handlerContext.getInputValue("name");
	HashMap result = new HashMap();
	
	try {
	    result = SipSecurityHelper.getTrustConfigInfo(name, configName);
	} catch (Exception ex) {
	    GuiUtil.handleException(handlerContext, ex);
	}
	handlerContext.setOutputValue("attrMap", result);
	HashMap handlerProps = (HashMap) result.remove("trustHandler_props");
	handlerContext.setOutputValue("HandlerProps", handlerProps);
	
	// Handler Entities
	List entities = (List) result.remove("trustedEntities");
	handlerContext.setOutputValue("HandlerEntities", entities);
    }
    
    
    @Handler(id="saveTrustConfig",
    input={
	@HandlerInput(name="ConfigName", type=String.class, required=true),
	@HandlerInput(name="Name", type=String.class, required=true),
	@HandlerInput(name="attrMap", type=Map.class),
	@HandlerInput(name="AddProps", type=Map.class),
	@HandlerInput(name="RemoveProps", type=List.class)
    })
    public static void saveTrustConfig(HandlerContext handlerContext) {
	String configName = (String) handlerContext.getInputValue("ConfigName");
	String trustConfigName = (String) handlerContext.getInputValue("Name");
	HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
	HashMap addProps = (HashMap) handlerContext.getInputValue("AddProps");
	ArrayList removeProps = (ArrayList) handlerContext.getInputValue("RemoveProps");
	try {
	    // Save Trust Config Attributes
	    Boolean isDefaultTrust = (Boolean) attrMap.remove("isDefault");
	    if (isDefaultTrust == null) {
		isDefaultTrust = false;
	    }
	    HashMap attributes = new HashMap();
	    attributes.put("is-default", isDefaultTrust);
	    ObjectName trustConfig = SipSecurityHelper.getTrustConfig(configName, trustConfigName);
	    SipUtil.setAttributeValues(trustConfig, attributes);
	    
	    // Save Trust Handler props as trust entities will be saved in their own page
	    SipSecurityHelper.saveTrustHandlerInfo(trustConfig, attrMap, addProps, removeProps);
	} catch (Exception ex) {
	    GuiUtil.handleException(handlerContext, ex);
	}
    }
    
    @Handler(id="getTrustedEntityInfo",
    input={
	@HandlerInput(name="ConfigName", type=String.class, required=true),
	@HandlerInput(name="TrustConfigName", type=String.class, required=true),
	@HandlerInput(name="TrustedEntityName", type=String.class),
	@HandlerInput(name="Edit", type=Boolean.class, required=true)
    },
    output={
	@HandlerOutput(name="AttrMap", type=Map.class)
    })
    public static void getTrustedEntityInfo(HandlerContext handlerContext) {
	String configName = (String) handlerContext.getInputValue("ConfigName");
	String trustConfigName = (String) handlerContext.getInputValue("TrustConfigName");
	boolean edit = ((Boolean) handlerContext.getInputValue("Edit")).booleanValue();
	
	HashMap attrMap = new HashMap();
	try {
	    ObjectName trustConfig = SipSecurityHelper.getTrustConfig(configName, trustConfigName);
	    if (edit) {
		String entityName = (String) handlerContext.getInputValue("TrustedEntityName");
		if (entityName == null || (entityName.trim().length() == 0)) {
		    throw new Exception("Trusted Entity Name is required");
		}
		attrMap = SipSecurityHelper.getTrustedEntityInfo(trustConfig, entityName);
		attrMap.put("pageTitle", "Edit Trusted Entity");
		attrMap.put("pageTitleHelp", "Edit the selected trusted entity");
		attrMap.put("showNewProps", false);
		attrMap.put("showEditProps", true);
	    } else {
		attrMap.put("pageTitle", "Create Trusted Entity");
		attrMap.put("pageTitleHelp", "Create trusted entity");
		attrMap.put("showNewProps", true);
		attrMap.put("showEditProps", false);
	    }
	} catch (Exception ex) {
	    GuiUtil.handleException(handlerContext, ex);
	}
		
	handlerContext.setOutputValue("AttrMap", attrMap);
    }
    
    @Handler(id="manageTrustedEntity",
    input={
	@HandlerInput(name="ConfigName", type=String.class, required=true),
	@HandlerInput(name="TrustConfigName", type=String.class, required=true),
	@HandlerInput(name="AttrMap", type=Map.class),
	@HandlerInput(name="Edit", type=Boolean.class)
    })
    public static void manageTrustedEntity(HandlerContext handlerContext) {
	String configName = (String) handlerContext.getInputValue("ConfigName");
	String trustConfigName = (String) handlerContext.getInputValue("TrustConfigName");
	boolean edit = ((Boolean) handlerContext.getInputValue("Edit")).booleanValue();
	
	HashMap attrMap = (HashMap) handlerContext.getInputValue("AttrMap");
	try {
	    ObjectName trustConfig = SipSecurityHelper.getTrustConfig(configName, trustConfigName);
            String trustedAs = (String) attrMap.get("entityTrustedAs");
            
            HashMap attributes = new HashMap();
            attributes.put("ip-address", (String) attrMap.get("entityIPAddress"));
            attributes.put("host-name", (String) attrMap.get("entityDomainName"));
            attributes.put("principal", (String) attrMap.get("entityPrincipal"));
            
            if(!GuiUtil.isEmpty(trustedAs)) {
                attributes.put("trusted-as", trustedAs);
            } else {
                attributes.put("trusted-as", null);
            }
            
	    if (edit) {
		// save the entity
		String entityName = (String) attrMap.get("entityName");
		ObjectName trustedEntity = (ObjectName) SipUtil.getChildByFunction(trustConfig, "getTrustedEntityById",
			new Object[] {entityName}, new String[]{"java.lang.String"});
                SipUtil.setAttributeValues(trustedEntity, attributes);
	    } else {
		//Create new Entity
		attributes.put("id", (String) attrMap.get("entityName"));
        	AttributeList attributeList = SipUtil.convertMapToAttributeList(attributes);
		JMXUtil.invoke(SipUtil.getSipConfigsObject(), "createTrustedEntity",
			new Object[]{attributeList, trustConfigName, configName},
			new String[]{"javax.management.AttributeList", "java.lang.String",
			"java.lang.String"});
		
	    }
	} catch (Exception ex) {
	    GuiUtil.handleException(handlerContext, ex);
	}
    }
    
    @Handler(id="deleteTrustedEntity",
    input={
        @HandlerInput(name="ConfigName", type=String.class, required=true),
        @HandlerInput(name="SelectedRows", type=List.class),
	@HandlerInput(name="TrustConfigName", type=String.class, required=true)
    })
    public static void deleteTrustedEntity(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("ConfigName");
        List<Map> rows = (List) handlerContext.getInputValue("SelectedRows");
	String trustConfigName = (String) handlerContext.getInputValue("TrustConfigName");
	
        try {
            for (Map oneRow : rows) {
                String id = (String) oneRow.get("name");
		//ObjectName trustConfig = SipSecurityHelper.getTrustConfig(configName, trustConfigName);
		Object params[] = new Object[]{id, trustConfigName, configName};
		String types[] = SipUtil.getSignatureArray(params);
		JMXUtil.invoke(SipUtil.getSipConfigsObject(), "deleteTrustedEntity",
			params, types);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
            
    }
    
}
