/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.admin.gui.extensions.handlers;

import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.annotation.Handler;
import com.sun.jsftemplating.annotation.HandlerInput;
import com.sun.jsftemplating.annotation.HandlerOutput;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import javax.management.ObjectName;

import org.jvnet.glassfish.comms.admin.gui.extensions.util.SipContainerHelper;
import org.jvnet.glassfish.comms.admin.gui.extensions.util.SipUtil;
import com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver;

/**
 *
 * @author irfan@sun.com
 */
public class SipContainerHandler {
    
    @Handler(id="getSipContainerGeneralProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="properties", type=Map.class),
        @HandlerOutput(name="attrMap", type=Map.class)
    })
    public static void getSipContainerProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap();
        HashMap props = new HashMap();
        try {
            ObjectName sipContainer = SipContainerHelper.getSipContainerObject(configName);
            attrMap = SipContainerHelper.getContainerAttributes(sipContainer);
            props = SipUtil.getProperties(sipContainer);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("properties", props);
        handlerContext.setOutputValue("attrMap", attrMap);
    }
    
    
    @Handler(id="saveSipContainerGeneralProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipContainerGeneralProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName sipContainer = SipContainerHelper.getSipContainerObject(configName);
            SipContainerHelper.saveContainerAttributes(sipContainer, attrMap);
            SipUtil.setProperties(sipContainer, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="getSipSessionProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class),
        @HandlerOutput(name="properties", type=Map.class)
    })
    public static void getSipSessionProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap(0);
        HashMap props = new HashMap(0);
        try {
            ObjectName sessionObject = SipContainerHelper.getSessionPropertiesObject(configName);
            if (sessionObject != null) {
                attrMap = SipContainerHelper.getSessionPropertiesAttributes(sessionObject);
                props = SipUtil.getProperties(sessionObject);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("attrMap", attrMap);
        handlerContext.setOutputValue("properties", props);
    }
    
    @Handler(id="saveSipSessionProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipSessionProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName sessionObject = SipContainerHelper.getSessionPropertiesObject(configName);
            if (sessionObject == null) {
                //create session config
                ObjectName sessionConfig = SipUtil.createChildByFunction(SipContainerHelper.getSipContainerObject(configName),
                        "createSessionConfig");
                sessionObject = SipUtil.createChildByFunction(sessionConfig, "createSessionProperties");
            }
            SipContainerHelper.saveSessionPropertiesAttributes(sessionObject, attrMap);
            SipUtil.setProperties(sessionObject, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="getSipManagerProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class),
        @HandlerOutput(name="properties", type=Map.class)
    })
    public static void getSipManagerProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap(0);
        HashMap props = new HashMap(0);
        try {
            ObjectName managerObject = SipContainerHelper.getManagerPropertiesObject(configName);
            if (managerObject != null) {
                attrMap = SipContainerHelper.getManagerPropertiesAttributes(managerObject);
                props = SipUtil.getProperties(managerObject);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("attrMap", attrMap);
        handlerContext.setOutputValue("properties", props);
    }
    
    @Handler(id="saveSipManagerProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipManagerProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName managerObject = SipContainerHelper.getManagerPropertiesObject(configName);
            if (managerObject == null) {
                //create manager-properties
                ObjectName parent = SipUtil.createChildByFunction(SipContainerHelper.getSipContainerObject(configName),
                        "createSessionConfig");
                //create session-manager
                parent = SipUtil.createChildByFunction(parent, "createSessionManager");
                managerObject = SipUtil.createChildByFunction(parent, "createManagerProperties");
            }
            SipContainerHelper.saveManagerPropertiesAttributes(managerObject, attrMap);
            SipUtil.setProperties(managerObject, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="getSipStoreProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class),
        @HandlerOutput(name="properties", type=Map.class)
    })
    public static void getSipStoreProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap(0);
        HashMap props = new HashMap(0);
        try {
            ObjectName storeObject = SipContainerHelper.getStorePropertiesObject(configName);
            if (storeObject != null) {
                attrMap = SipContainerHelper.getStorePropertiesAttributes(storeObject);
                props = SipUtil.getProperties(storeObject);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("attrMap", attrMap);
        handlerContext.setOutputValue("properties", props);
    }
    
    @Handler(id="saveSipStoreProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipStoreProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName storeObject = SipContainerHelper.getStorePropertiesObject(configName);
            if (storeObject == null) {
                //create manager-properties
                ObjectName parent = SipUtil.createChildByFunction(SipContainerHelper.getSipContainerObject(configName),
                        "createSessionConfig");
                //create session-manager
                parent = SipUtil.createChildByFunction(parent, "createSessionManager");
                storeObject = SipUtil.createChildByFunction(parent, "createStoreProperties");
            }
            SipContainerHelper.saveStorePropertiesAttributes(storeObject, attrMap);
            SipUtil.setProperties(storeObject, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    /**
     *	<p> This handler returns the values for the attributes in 
     *      Sip Container Availability Tab of Availability Service page </p>
     *	<p> Input value: "ConfigName"                   -- Type: <code>java.lang.String</code></p>
     *	<p> Output value: "AvailabilityEnabled"         -- Type: <code>java.lang.Boolean</code></p>
     *  <p> Output value: "PersistenceType"             -- Type: <code>java.lang.String</code></p>
     *  <p> Output value: "PersistenceFrequency"        -- Type: <code>java.lang.String</code></p>
     *  <p> Output value: "PersistenceScope"            -- Type: <code>java.lang.String</code></p>
     *  <p> Output value: "RepairDuringFailure"         -- Type: <code>java.lang.Boolean</code></p>
     *  <p> Output value: "Properties"                  -- Type: <code>java.util.Map</code></p>
     *	@param	context	The HandlerContext.
     */
    @Handler(id="getSipAvailabilitySettings",
    input={
        @HandlerInput(name="ConfigName", type=String.class, required=true)   
    },
    output={
        @HandlerOutput(name="AvailabilityEnabled",      type=Boolean.class),
        @HandlerOutput(name="PersistenceType",          type=String.class),
        @HandlerOutput(name="PersistenceFrequency",     type=String.class),
        @HandlerOutput(name="PersistenceScope",         type=String.class),
        @HandlerOutput(name="RepairDuringFailure",      type=Boolean.class),
        @HandlerOutput(name="Properties",               type=Map.class)
    })
    public static void getSipAvailabilitySettings(HandlerContext handlerContext) {
	String configName = (String) handlerContext.getInputValue("ConfigName");
	try {
	    ObjectName sipContainerAvailability = SipContainerHelper.getSipAvailabilityObject(configName);
	    String attributes[] = SipContainerHelper.getSipAvailabilityAttributesList();
	    HashMap attrMap = SipUtil.getAttributeValues(sipContainerAvailability, attributes);
	    handlerContext.setOutputValue("AvailabilityEnabled", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.AVAILABILITY_ENABLED));
	    handlerContext.setOutputValue("PersistenceType", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_TYPE));
	    handlerContext.setOutputValue("PersistenceFrequency", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_FREQUENCY));
	    handlerContext.setOutputValue("PersistenceScope", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_SCOPE));
	    handlerContext.setOutputValue("RepairDuringFailure",
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.REPAIR_DURING_FAILURE));

	    HashMap props = SipUtil.getProperties(sipContainerAvailability);
	    handlerContext.setOutputValue("Properties", props);
	} catch (Exception ex) {
	    GuiUtil.handleException(handlerContext, ex);
	}
    }
    
    /**
     *	<p> This handler saves the values for the attributes in 
     *      Sip Container Availability Tab of Availability Service page </p>
     *	<p> Input value: "ConfigName"                  -- Type: <code>java.lang.String</code></p>
     *	<p> Input value: "AvailabilityEnabled"         -- Type: <code>java.lang.Boolean</code></p>
     *  <p> Input value: "PersistenceType"             -- Type: <code>java.lang.String</code></p>
     *  <p> Input value: "PersistenceFrequency"        -- Type: <code>java.lang.String</code></p>
     *  <p> Input value: "PersistenceScope"            -- Type: <code>java.lang.String</code></p>
     *  <p> Input value: "RepairDuringFailure"         -- Type: <code>java.lang.Boolean</code></p>
     *  <p> Input value: "AddProps"                    -- Type: <code>java.util.Map</code></p>
     *  <p> Input value: "RemoveProps"                 -- Type: <code>java.util.ArrayList</code></p>
     *	@param	handlerContext	The HandlerContext.
     */
    @Handler(id="saveSipAvailabilitySettings",
    input={
        @HandlerInput(name="ConfigName",               type=String.class, required=true),   
        @HandlerInput(name="AvailabilityEnabled",      type=Boolean.class),
        @HandlerInput(name="PersistenceType",          type=String.class),
        @HandlerInput(name="PersistenceFrequency",     type=String.class),
        @HandlerInput(name="PersistenceScope",         type=String.class),
        @HandlerInput(name="RepairDuringFailure",      type=Boolean.class),
        @HandlerInput(name="HttpSessionStore",         type=String.class),
        @HandlerInput(name="PersistenceHealthCheck",   type=Boolean.class),
        @HandlerInput(name="AddProps",                 type=Map.class),
        @HandlerInput(name="RemoveProps",              type=ArrayList.class)
    })
    public static void saveWebAvailabilitySettings(HandlerContext handlerContext) {
	String configName = (String) handlerContext.getInputValue("ConfigName");
	try {
	    ObjectName sipAvailability = SipContainerHelper.getSipAvailabilityObject(configName);
	    HashMap attrMap = new HashMap();
	    Boolean availabilityEnabled = (Boolean) handlerContext.getInputValue("AvailabilityEnabled");
	    if (availabilityEnabled == null) {
		availabilityEnabled = false;
	    }
	    attrMap.put(SipContainerHelper.SipContainerAvailabilityKeys.AVAILABILITY_ENABLED, 
		    availabilityEnabled);
	    attrMap.put(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_FREQUENCY,
		    handlerContext.getInputValue("PersistenceFrequency"));
	    attrMap.put(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_SCOPE,
		    handlerContext.getInputValue("PersistenceScope"));
	    attrMap.put(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_TYPE,
		    handlerContext.getInputValue("PersistenceType"));
	    Boolean repairDuringFailure = (Boolean) handlerContext.getInputValue("RepairDuringFailure");
	    if (repairDuringFailure == null) {
		repairDuringFailure = false;
	    }
	    attrMap.put(SipContainerHelper.SipContainerAvailabilityKeys.REPAIR_DURING_FAILURE,
		    repairDuringFailure);
	    SipUtil.setAttributeValues(sipAvailability, attrMap);
	    
	    ArrayList removeProps = (ArrayList) handlerContext.getInputValue("RemoveProps");
	    HashMap addProps = (HashMap) handlerContext.getInputValue("AddProps");
	    SipUtil.setProperties(sipAvailability, addProps, removeProps);
	    
	} catch (Exception ex) {
	    GuiUtil.handleException(handlerContext, ex);
	}
    }
    
    /**
     *	<p> This handler returns the default values for the attributes persistence-frequency in
     *      Sip Container Availability Tab of Availability Service page </p>
     *  <p> Output value: "PersistenceFrequencyList"    -- Type: <code>SelectItem[].class</code></p>
     *	@param	context	The HandlerContext.
     */
    @Handler(id="getSipAvailabilityLists",
    output={
        @HandlerOutput(name="PersistenceFrequencyList", type=SelectItem[].class),
       	@HandlerOutput(name="PersistenceTypeList", type=SelectItem[].class),
	@HandlerOutput(name="PersistenceScopeList", type=SelectItem[].class)
    })
    public static void getSipAvailabilityLists(HandlerContext handlerContext) {
        EEPersistenceTypeResolver resolver = new EEPersistenceTypeResolver();
        List persistenceList = resolver.getWebDefinedPersistenceTypes();
        String[] persistenceFrequency = (String[]) SipContainerHelper.SipSessionSaveFrequencyList.toArray(
                new String[SipContainerHelper.SipSessionSaveFrequencyList.size()]); 
        persistenceList.remove(EEPersistenceTypeResolver.FILE_TYPE);
        String[] persistenceTypes = (String[])persistenceList.toArray(new String[persistenceList.size()]);
        String[] persistenceScopes = (String[]) SipContainerHelper.SipSessionPersistenceScopeList.toArray(
                new String[SipContainerHelper.SipSessionPersistenceScopeList.size()]);
        handlerContext.setOutputValue("PersistenceFrequencyList", 
		ConfigurationHandlers.getOptions(persistenceFrequency));      
        handlerContext.setOutputValue("PersistenceTypeList", 
                ConfigurationHandlers.getOptions(persistenceTypes)); 
        handlerContext.setOutputValue("PersistenceScopeList", 
                ConfigurationHandlers.getOptions(persistenceScopes));
   }
    
    /**
     *	<p> This handler returns the default values for the attributes in 
     *      Sip Container Availability Tab of Availability Service page </p>
     *	<p> Input value: "ConfigName"                   -- Type: <code>java.lang.String</code></p>
     *	<p> Output value: "AvailabilityEnabled"         -- Type: <code>java.lang.Boolean</code></p>
     *  <p> Output value: "PersistenceType"             -- Type: <code>java.lang.String</code></p>
     *  <p> Output value: "PersistenceFrequency"        -- Type: <code>java.lang.String</code></p>
     *  <p> Output value: "PersistenceScope"            -- Type: <code>java.lang.String</code></p>
     *  <p> Output value: "RepairDuringFailure"         -- Type: <code>java.lang.Boolean</code></p>
     *  <p> Output value: "Properties"                  -- Type: <code>java.util.Map</code></p>
     *	@param	context	The HandlerContext.
     */
    @Handler(id="getDefaultSipAvailabilitySettings",
    input={
	@HandlerInput(name="ConfigName", type=String.class, required=true)
    },
    output={
	@HandlerOutput(name="AvailabilityEnabled",      type=Boolean.class),
        @HandlerOutput(name="PersistenceType",          type=String.class),
        @HandlerOutput(name="PersistenceFrequency",     type=String.class),
        @HandlerOutput(name="PersistenceScope",         type=String.class),
        @HandlerOutput(name="RepairDuringFailure",      type=Boolean.class),
        @HandlerOutput(name="Properties",               type=Map.class)
    })
    public static void getDefaultSipAvailabilitySettings(HandlerContext handlerContext) {
	String configName = (String) handlerContext.getInputValue("ConfigName");
	try {
	    HashMap attrMap = SipUtil.getDefaultAttributeValues(
		    SipContainerHelper.SipContainerAvailabilityKeys.ELEMENT_NAME);
	    handlerContext.setOutputValue("AvailabilityEnabled", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.AVAILABILITY_ENABLED));
	    handlerContext.setOutputValue("PersistenceType", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_TYPE));
	    handlerContext.setOutputValue("PersistenceFrequency", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_FREQUENCY));
	    handlerContext.setOutputValue("PersistenceScope", 
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.PERSISTENCE_SCOPE));
	    handlerContext.setOutputValue("RepairDuringFailure",
		    attrMap.get(SipContainerHelper.SipContainerAvailabilityKeys.REPAIR_DURING_FAILURE));

	    ObjectName sipContainerAvailability = SipContainerHelper.getSipAvailabilityObject(configName);
	    HashMap props = SipUtil.getProperties(sipContainerAvailability);
	    handlerContext.setOutputValue("Properties", props);
	} catch (Exception ex) {
	    GuiUtil.handleException(handlerContext, ex);
	}
    }
}
