/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.admin.gui.extensions.util;

import com.sun.enterprise.admin.config.MBeanConfigInstanceNotFoundException;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.ObjectName;

/**
 *
 * @author irfan@sun.com
 */
public class SipContainerHelper {
    
    /** This is ObjectName for sip-container. Append ,config=configName to get the correct element */
    public static final String SIP_CONTAINER_OBJECT_NAME    = "com.sun.appserv:type=sip-container,category=config";
    public static final String SIP_AVAILABILITY_OBJECT_NAME    = "com.sun.appserv:type=sip-container-availability,category=config";

    public static interface SipContainerKeys {
        public static final String ELEMENT_NAME         = "sip-container";
        public static final String EXTERNAL_ADDRESS     = "external-address";
        public static final String EXTERNAL_SIP_PORT    = "external-sip-port";
        public static final String EXTERNAL_SIPS_PORT   = "external-sips-port";
    }
    
    public static interface SessionPropertiesKeys {
        public static final String ELEMENT_NAME         = "session-properties";
        public static final String TIMEOUT_IN_SECONDS   = "timeout-in-seconds";
    }
    
    public static interface ManagerPropertiesKeys {
        public static final String ELEMENT_NAME     = "manager-properties";
        public static final String SESSION_ID_GENERATOR_CLASSNAME   = "session-id-generator-classname";
        public static final String REAP_INTERVAL_IN_SECONDS         = "reap-interval-in-seconds";
        public static final String MAX_SESSIONS                     = "max-sessions";
        public static final String SESSION_FILE_NAME                = "session-file-name";
    }
    
    public static interface StorePropertiesKeys {
        public static final String ELEMENT_NAME		    = "store-properties";
        public static final String DIRECTORY                = "directory";
        public static final String REAP_INTERVAL_IN_SECONDS = "reap-interval-in-seconds";
    }
    
    public static interface SipContainerAvailabilityKeys {
	public static final String ELEMENT_NAME		    = "sip-container-availability";
	public static final String AVAILABILITY_ENABLED	    = "availability-enabled";
	public static final String PERSISTENCE_TYPE	    = "persistence-type";
	public static final String PERSISTENCE_FREQUENCY    = "persistence-frequency";
	public static final String PERSISTENCE_SCOPE	    = "persistence-scope";
	public static final String REPAIR_DURING_FAILURE    = "repair-during-failure";
    }
    
    public static final List SipSessionSaveFrequencyList = new ArrayList();
    public static final List SipSessionPersistenceScopeList = new ArrayList();
    
    static {
        SipSessionSaveFrequencyList.add("sip-transaction");
        SipSessionPersistenceScopeList.add("session");
        SipSessionPersistenceScopeList.add("modified-session");
    };

    public static ObjectName getSipContainerObject(String configName) throws Exception {
        String objectName = SIP_CONTAINER_OBJECT_NAME + ",config=" + configName;
        return new ObjectName(objectName);
    }
    
    public static HashMap getContainerAttributes(ObjectName sipContainer) throws Exception {
        HashMap attrMap = new HashMap();
        String address = (String) JMXUtil.getAttribute(sipContainer, SipContainerKeys.EXTERNAL_ADDRESS);
        String port = (String) JMXUtil.getAttribute(sipContainer, SipContainerKeys.EXTERNAL_SIP_PORT);
        String securePort = (String) JMXUtil.getAttribute(sipContainer, SipContainerKeys.EXTERNAL_SIPS_PORT);
        attrMap.put("callBackAddress", address);
        attrMap.put("callBackPort", port);
        attrMap.put("callBackSecurePort", securePort);
        return attrMap;
    }

    public static void saveContainerAttributes(ObjectName sipContainer, HashMap attrMap) {
        HashMap map = new HashMap(attrMap.size());
        map.put(SipContainerKeys.EXTERNAL_ADDRESS, attrMap.get("callBackAddress"));
        map.put(SipContainerKeys.EXTERNAL_SIP_PORT, attrMap.get("callBackPort"));
        map.put(SipContainerKeys.EXTERNAL_SIPS_PORT, attrMap.get("callBackSecurePort"));
        
        SipUtil.setAttributeValues(sipContainer, map);
    }
    
    public static ObjectName getSessionPropertiesObject(String configName) throws Exception {
        ObjectName sipContainer = getSipContainerObject(configName);
        try {
            // session properties are within session config
            ObjectName sessionConfig = (ObjectName)SipUtil.getChildByFunction(sipContainer, "getSessionConfig");
            return (ObjectName)SipUtil.getChildByFunction(sessionConfig, "getSessionProperties");
        } catch (Exception ex) {
            if (ex instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw ex;
        }
    }

    public static HashMap getSessionPropertiesAttributes(ObjectName sessionObject) {
        HashMap attrMap = new HashMap();
        String sessionTimeout = (String) JMXUtil.getAttribute(sessionObject, 
                SessionPropertiesKeys.TIMEOUT_IN_SECONDS);
        attrMap.put("sessionTimeout", sessionTimeout);
        return attrMap;
    }

    public static void saveSessionPropertiesAttributes(ObjectName sessionObject, HashMap attrMap) {
        HashMap map = new HashMap(attrMap.size());
        map.put(SessionPropertiesKeys.TIMEOUT_IN_SECONDS, attrMap.get("sessionTimeout"));
        
        SipUtil.setAttributeValues(sessionObject, map);
    }

    public static ObjectName getManagerPropertiesObject(String configName) throws Exception {
        ObjectName sipContainer = getSipContainerObject(configName);
        try {
            // manager properties are within session manager which is in session config
            ObjectName sessionConfig = (ObjectName)SipUtil.getChildByFunction(sipContainer, "getSessionConfig");
            ObjectName managerObject = (ObjectName)SipUtil.getChildByFunction(sessionConfig, "getSessionManager");
            return (ObjectName)SipUtil.getChildByFunction(managerObject, "getManagerProperties");
        } catch (Exception ex) {
            if (ex instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw ex;
        }
    }

    public static HashMap getManagerPropertiesAttributes(ObjectName managerObject) {
        HashMap attrMap = new HashMap();
        String sessionIdGen = (String) JMXUtil.getAttribute(managerObject, 
                ManagerPropertiesKeys.SESSION_ID_GENERATOR_CLASSNAME);
        String reapInterval = (String) JMXUtil.getAttribute(managerObject, 
                ManagerPropertiesKeys.REAP_INTERVAL_IN_SECONDS);
        String maxSessions = (String) JMXUtil.getAttribute(managerObject, 
                ManagerPropertiesKeys.MAX_SESSIONS);
        String sessionFileName = (String) JMXUtil.getAttribute(managerObject, 
                ManagerPropertiesKeys.SESSION_FILE_NAME);
        
        attrMap.put("sessionIdGen", sessionIdGen);
        attrMap.put("reapInterval", reapInterval);
        attrMap.put("maxSessions", maxSessions);
        attrMap.put("sessionFileName", sessionFileName);
        return attrMap;
    }

    public static void saveManagerPropertiesAttributes(ObjectName managerObject, HashMap attrMap) {
        HashMap map = new HashMap(attrMap.size());
        map.put(ManagerPropertiesKeys.SESSION_ID_GENERATOR_CLASSNAME, attrMap.get("sessionIdGen"));
        map.put(ManagerPropertiesKeys.SESSION_FILE_NAME, attrMap.get("sessionFileName"));
        map.put(ManagerPropertiesKeys.REAP_INTERVAL_IN_SECONDS, attrMap.get("reapInterval"));
        map.put(ManagerPropertiesKeys.MAX_SESSIONS, attrMap.get("maxSessions"));
        
        SipUtil.setAttributeValues(managerObject, map);
    }

    public static ObjectName getStorePropertiesObject(String configName) throws Exception{
        ObjectName sipContainer = getSipContainerObject(configName);
        try {
            // store properties are within session manager which is in session config
            ObjectName sessionConfig = (ObjectName)SipUtil.getChildByFunction(sipContainer, "getSessionConfig");
            ObjectName managerObject = (ObjectName)SipUtil.getChildByFunction(sessionConfig, "getSessionManager");
            return (ObjectName)SipUtil.getChildByFunction(managerObject, "getStoreProperties");
        } catch (Exception ex) {
            if (ex instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw ex;
        }
    }

    public static HashMap getStorePropertiesAttributes(ObjectName storeObject) {
        HashMap attrMap = new HashMap();
        String directory = (String) JMXUtil.getAttribute(storeObject, 
                StorePropertiesKeys.DIRECTORY);
        String reapInterval = (String) JMXUtil.getAttribute(storeObject, 
                StorePropertiesKeys.REAP_INTERVAL_IN_SECONDS);
        
        attrMap.put("directory", directory);
        attrMap.put("reapInterval", reapInterval);
        return attrMap;
    }

    public static void saveStorePropertiesAttributes(ObjectName storeObject, HashMap attrMap) {
        HashMap map = new HashMap(attrMap.size());
        map.put(StorePropertiesKeys.DIRECTORY, attrMap.get("directory"));
        map.put(StorePropertiesKeys.REAP_INTERVAL_IN_SECONDS, attrMap.get("reapInterval"));
        
        SipUtil.setAttributeValues(storeObject, map);
    }
    
    /** This function gets the sip-container-availability ObjectName for a given Config name
     * 
     * @param configName
     * @return the ObjectName for the corresponding sip-container-availability element
     */
    public static ObjectName getSipAvailabilityObject(String configName) throws Exception {
	String objectName = SIP_AVAILABILITY_OBJECT_NAME + ",config=" + configName;
        return new ObjectName(objectName);
    }
    
    /** 
     *	The function returns the attributes for the sip container availability element
     * @return String[] of attrubute lists
     */
    public static String[] getSipAvailabilityAttributesList() {
	String attrList[] = new String[] {
	    SipContainerAvailabilityKeys.AVAILABILITY_ENABLED, SipContainerAvailabilityKeys.PERSISTENCE_FREQUENCY,
	    SipContainerAvailabilityKeys.PERSISTENCE_SCOPE, SipContainerAvailabilityKeys.PERSISTENCE_TYPE,
	    SipContainerAvailabilityKeys.REPAIR_DURING_FAILURE
	};
	return attrList;
    }
}
