/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.admin.management.extensions.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import org.jvnet.glassfish.comms.management.config.ConvergedLBClusterRefConfigCR;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;

import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;

import org.jvnet.glassfish.comms.admin.management.extensions.support.oldconfig.OldConvergedLBConfigMBean;

public final class ConvergedLBClusterRefConfigFactory extends ConfigFactory
{
    private final OldConvergedLBConfigMBean mOldConvergedLBConfigMBean;

    public ConvergedLBClusterRefConfigFactory( final ConfigFactoryCallback callbacks )
    {
        super( callbacks );
        final String containerName = getFactoryContainer().getName();
        mOldConvergedLBConfigMBean = OldConfigProxies.getInstance(getMBeanServer())
                            .newProxy( "type=converged-lb-config"+containerName, OldConvergedLBConfigMBean.class );
    }
    
    private final Set<String>    LEGAL_OPTIONAL_KEYS    = 
        GSetUtil.newUnmodifiableStringSet(
            ConvergedLBClusterRefConfigCR.REF_KEY,
            ConvergedLBClusterRefConfigCR.SELF_LOADBALANCE_KEY );
        
    protected Map<String,String> getParamNameOverrides() {
        return(MapUtil.newMap(CONFIG_NAME_KEY, "ref"));
    }

    protected Set<String> getLegalOptionalCreateKeys()
    {
        return( LEGAL_OPTIONAL_KEYS );
    }

    protected ObjectName createOldChildConfig(final AttributeList translatedAttrs) {
        return mOldConvergedLBConfigMBean.createConvergedLBClusterRef(translatedAttrs);
    }

    public ObjectName create(final String referencedClusterName,
        final Map<String,String> optional) {

        final String[] requiredParams = new String[] {};
        final Map<String,String> params = initParams(referencedClusterName, requiredParams, optional);
        final ObjectName amxName = createNamedChild(referencedClusterName, params);
        return(amxName);
    }

    public void removeByName(final String referencedClusterName)        {
        mOldConvergedLBConfigMBean.removeConvergedLBClusterRefByRef(referencedClusterName);
    }
}
