/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.admin.management.extensions.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import org.jvnet.glassfish.comms.management.config.ConvergedLoadBalancerConfigKeys;

import org.jvnet.glassfish.comms.admin.management.extensions.support.oldconfig.OldSIPAvailabilityServiceMBean;
import org.jvnet.glassfish.comms.admin.management.extensions.support.oldconfig.OldConvergedLBConfigsMBean;

import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;

public final class ConvergedLoadBalancerConfigFactory extends ConfigFactory
{
    private final OldSIPAvailabilityServiceMBean    mOldSIPAvailabilityServiceMBean;
    private final OldConvergedLBConfigsMBean        mOldConvergedLBConfigsMBean;

    public ConvergedLoadBalancerConfigFactory( final ConfigFactoryCallback callbacks )
    {
        super( callbacks );
        mOldSIPAvailabilityServiceMBean = OldConfigProxies.getInstance(getMBeanServer()).newProxy( "type=security-service", OldSIPAvailabilityServiceMBean.class );
        mOldConvergedLBConfigsMBean = OldConfigProxies.getInstance(getMBeanServer())
                                      .newProxy( "type=converged-lb-configs", OldConvergedLBConfigsMBean.class );
    }
    
    private final Set<String>    LEGAL_OPTIONAL_KEYS    = 
        GSetUtil.newUnmodifiableStringSet(
            ConvergedLoadBalancerConfigKeys.NAME_KEY,
            ConvergedLoadBalancerConfigKeys.AUTO_COMMIT_KEY,
            ConvergedLoadBalancerConfigKeys.CONFIG_FILE_KEY,
            ConvergedLoadBalancerConfigKeys.CONVERGED_LB_CONFIG_NAME_KEY );
        
    protected Set<String> getLegalOptionalCreateKeys()
    {
        return( LEGAL_OPTIONAL_KEYS );
    }

    public ObjectName create( final Map<String,String> optional )
    {
        final Map<String,String> params = initParams( optional );

        final ObjectName amxName = createChild( params );
        
        return( amxName );
    }

    protected void internalRemove( final ObjectName objectName )
    {
        mOldSIPAvailabilityServiceMBean.removeConvergedLoadBalancer();
    }

    protected ObjectName createOldChildConfig( final AttributeList attrs )
    {
        final ObjectName oldObjectName = mOldSIPAvailabilityServiceMBean.createConvergedLoadBalancer( attrs );
        return oldObjectName;
    }
}
