/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.admin.management.extensions.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import org.jvnet.glassfish.comms.management.config.SIPServiceConfig;
import org.jvnet.glassfish.comms.management.config.SIPListenerConfigKeys;

import org.jvnet.glassfish.comms.admin.management.extensions.support.oldconfig.OldSIPServiceMBean;

public final class SIPListenerConfigFactory extends ConfigFactory
{
    private final OldSIPServiceMBean    mOldSIPServiceMBean;
    
    public SIPListenerConfigFactory( final ConfigFactoryCallback callbacks )
    {
        super( callbacks );
        
        mOldSIPServiceMBean = OldConfigProxies.getInstance(getMBeanServer()).newProxy( "type=sip-service,config=" + getConfigName(), OldSIPServiceMBean.class );
    }
    
    private final Set<String>    LEGAL_OPTIONAL_KEYS    = 
        GSetUtil.newUnmodifiableStringSet( 
        SIPListenerConfigKeys.ADDRESS_KEY,
        SIPListenerConfigKeys.PORT_KEY,
        SIPListenerConfigKeys.ENABLED_KEY,
        SIPListenerConfigKeys.TRANSPORT_KEY );
    
    protected Set<String> getLegalOptionalCreateKeys()
    {
        return( LEGAL_OPTIONAL_KEYS );
    }
    
    protected Map<String,String> getParamNameOverrides()
    {
        return( MapUtil.newMap( CONFIG_NAME_KEY, "id" ) );
    }
    
    protected ObjectName createOldChildConfig( final AttributeList translatedAttrs )
    {
        return mOldSIPServiceMBean.createSipListener( translatedAttrs );
    }
    
    public ObjectName create(
        final String    name,
        final String    address,
        final int        port,
        final Map<String,String>        options )
    {
        final String[] requiredParams =
        {
            SIPListenerConfigKeys.ADDRESS_KEY,                address,
            SIPListenerConfigKeys.PORT_KEY,                    "" + port,
        };
        
        final Map<String,String> params    = initParams( name, requiredParams, options );

        final ObjectName    amxName    = createNamedChild( name, params );
        
        return( amxName );
    }
    
    protected final void removeByName( String name )
    {
        mOldSIPServiceMBean.removeSipListenerById( name );
    }
}
