/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.admin.management.extensions.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;
import java.util.Properties;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;

import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;

import org.jvnet.glassfish.comms.admin.management.extensions.support.oldconfig.OldIdentityAssertionTrustMBean;

public final class TrustHandlerConfigFactory extends ConfigFactory
{
    private final OldIdentityAssertionTrustMBean    mOldIdentityAssertionTrustMBean;
    
    public TrustHandlerConfigFactory( final ConfigFactoryCallback callbacks )
    {
        super( callbacks );
        
        mOldIdentityAssertionTrustMBean = OldConfigProxies.getInstance(getMBeanServer()).newProxy( "type=identity-assertion-trust", OldIdentityAssertionTrustMBean.class);
    }
    
    public ObjectName create( final Map<String,String> optional )
    {
        final Map<String,String> params                 = initParams( optional );

        final ObjectName        amxName = createChild( params );

        return( amxName );
    }

    public void internalRemove( final ObjectName objectName )
    {
        mOldIdentityAssertionTrustMBean.removeTrustHandler();
    }

    protected ObjectName createOldChildConfig( AttributeList attrs )
    {
        return mOldIdentityAssertionTrustMBean.createTrustHandler( attrs );
    }
}
