/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.management.config;

import java.util.Map;
import java.util.Date;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;

import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ConfigElement;

/**
   Configuration for the CLB proxy element.
   @see org.jvnet.glassfish.comms.management.config.ConvergedLoadBalancer
 */
public interface ProxyConfig extends
        ConfigElement, PropertiesAccess
{

    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String  J2EE_TYPE = SIPXTypes.PROXY_CONFIG;

    /**
        Gets the request pool size
     */
    public String getRequestPoolSize();

    /**
        Specify the number of request objects that will be created
        and pooled by the proxy
     */
    public void setRequestPoolSize( final String poolSize);

    /**
        Gets the send retry count
     */
    public String getSendRetryCount();

    /**
        The number of retries the proxy would attempt with the remote
        instance when sending of data fails.
     */
    public void setSendRetryCount( final String count);

    /**
        Gets the value of read timeout in milli seconds
     */
    public String getReadTimeoutInMillis();

    /**
        Sets the duration we would wait for data from the client
        in the socket channel
     */
    public void setReadTimeoutInMillis( final String timeout);
}
