/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
 
package org.jvnet.glassfish.comms.management.config;

import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.config.ConfigElement;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.AccessLogConfig;
import com.sun.appserv.management.config.RequestProcessingConfig;
import com.sun.appserv.management.config.KeepAliveConfig;
import com.sun.appserv.management.config.ConnectionPoolConfig;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;

/**
     Configuration for the &lt;sip-service&gt; element.
 */
public interface SIPServiceConfig
    extends ConfigElement, PropertiesAccess, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String    J2EE_TYPE    = SIPXTypes.SIP_SERVICE_CONFIG;
    
    /**
        Calls Container.getContaineeMap( XTypes.SIP_LISTENER_CONFIG ).
        @return Map of all SIPListenerConfig proxies, keyed by the name of the listener.
        @see com.sun.appserv.management.base.Container#getContaineeMap
     */
    public Map<String,SIPListenerConfig>        getSIPListenerConfigMap();
    
    /**
        Creates access-log element with the given params.
        @param params
        @return Proxy to the AccessLogConfig MBean
        @see AccessLogConfigKeys
     */
    public AccessLogConfig    createAccessLogConfig( Map<String,String> params );

    /**
        Removes access-log element.
     */
    public void            removeAccessLogConfig();

    /**
        Creates request-processing element with the given params.
        @param params
        @return Proxy to the RequestProcessingConfig MBean
        @see RequestProcessingConfigKeys
     */
    public RequestProcessingConfig    createRequestProcessingConfig( Map<String,String> params );

    /**
        Removes request-processing element.
     */
    public void            removeRequestProcessingConfig();

    /**
        @return Proxy to the KeepAliveConfig MBean
     */
    public KeepAliveConfig    getKeepAliveConfig();

    /**
        Creates keep-alive element with the given params.
        @param params
        @return Proxy to the KeepAliveConfig MBean
        @see KeepAliveConfigKeys
     */
    public KeepAliveConfig    createKeepAliveConfig( Map<String,String> params );

    /**
        Removes keep-alive element.
     */
    public void            removeKeepAliveConfig();

    /**
        Creates connection-pool element with the given params.
        @param params
        @return the ObjectName of the ConnectionPoolConfig
        @see ConnectionPoolConfigKeys
     */
    public ConnectionPoolConfig    createConnectionPoolConfig( Map<String,String> params );

    /**
        Removes connection-pool element.
     */
    public void            removeConnectionPoolConfig();

    /**
        @return Proxy to the SIPProtocolConfig MBean
     */
    public SIPProtocolConfig    getSIPProtocolConfig();

    /**
        Creates sip-protocol element with the given params.
        @param params
        @return Proxy to the SIPProtocolConfig MBean
        @see SIPProtocolConfigKeys
     */
    public SIPProtocolConfig    createSIPProtocolConfig( Map<String,String> params );

    /**
        Removes sip-protocol element.
     */
    public void            removeSIPProtocolConfig();

    /**
        Create an <sip-listener>
        Parameters:
        <ul>
        <li>{@link SIPListenerConfigKeys#ADDRESS_KEY}</li>
        <li>{@link SIPListenerConfigKeys#PORT_KEY}</li>
        <li>{@link SIPListenerConfigKeys#ENABLED_KEY}</li>
        <li>{@link SIPListenerConfigKeys#TRANSPORT_KEY}</li>
        </ul>
     
        
        @param name         the name (id) of the newly created listener
        @param address        IP address of the listener
        @param port            port of the listener
        @param optional        optional parameters keyed by one of XXX_KEY
        @return A proxy to the SIPListenerConfig MBean
        @see SIPListenerConfigKeys
     */
    public SIPListenerConfig    createSIPListenerConfig(
                            String    name,
                            String    address,
                            int        port,
                            Map<String,String>        optional );
    
    /**
        Remove the &lt;sip-listener>.  Will fail if the &lt;sip-listener> is referred to by
        other elements.
        @param name        the name (id) of the sip listener to be removed.
     */
    public void            removeSIPListenerConfig( String name );
    
    /**
        Get the AccessLogConfig.
     */
    public AccessLogConfig    getAccessLogConfig();

    /**
        Get the RequestProcessingConfig.
     */
    public RequestProcessingConfig    getRequestProcessingConfig();

    /**
        Get the ConnectionPoolConfig.
     */
    public ConnectionPoolConfig    getConnectionPoolConfig();

}
