/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.management.config;

import org.jvnet.glassfish.comms.admin.management.extensions.SIPXTypes;
import com.sun.appserv.management.config.ConfigElement;
import com.sun.appserv.management.base.Container;

/**
 *     Configuration for the &lt;trusted-entity&gt; element.
 */

public interface TrustedEntityConfig
        extends ConfigElement, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String    J2EE_TYPE    = SIPXTypes.TRUSTED_ENTITY_CONFIG;

    /**
            Possible value for TrustedAs. See {@link #setTrustedAs}
     */
    public static final String   TRUSTED_AS_INTERMEDIATE = "intermediate";
    /**
            Possible value for TrustedAs. See {@link #setTrustedAs}
     */
    public static final String   TRUSTED_AS_DESTINATION = "destination";

    /**
        Get the identifier for the trusted entity
     */
    public String getId();

    /**
        Returns the value of trusted-as.
     */
    public String  getTrustedAs();

    /**
        Valid values are:
        <ul>
        <li>{@link #TRUSTED_AS_INTERMEDIATE}</li>
        <li>{@link #TRUSTED_AS_DESTINATION}</li>
        </ul>
        @param value
     */
    public void    setTrustedAs( final String value );

    // ------------------------- Operations -------------------
    /**
        Get the host name
     */
    public String    getHostName();

    /**
        Creates trusted host name identified using
        domain names.

        @param name Host name
     */
    public void      createHostName( String name );

    /**
        Removed the trusted host name from trusted-entity config
     */
    public void      removeHostName();

    /**
        Get the IP address of the trusted host
     */
    public String    getIpAddress();

    /**
        Creates the trusted host IP address element

        @name name IP address
     */
    public void      createIpAddress( String name );

    /**
        Removes the IP address from trusted entity
     */
    public void      removeIpAddress();


    /**
        Get the principal name
     */
    public String    getPrincipal();

    /**
        Creates the principal for the trusted entity
     */
    public void      createPrincipal( String name );

    /**
        Remove the principal from the trusted entity config
     */
    public void      removePrincipal( String name );
}
