<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml"
          indent="yes"
          doctype-public="-//Sun Microsystems Inc.//DTD Application Server 9.1 Domain//EN"
	  doctype-system="http://www.sun.com/software/appserver/dtds/sun-domain_1_4.dtd">
  </xsl:output>

 <xsl:variable name="bf" select="'sip-service http-service iiop-service admin-service connector-service web-container ejb-container mdb-container'" />
 <xsl:variable name="af" select="'jms-service log-service security-service transaction-service monitoring-service diagnostic-service java-config availability-service thread-pools alert-service group-management-service management-rules system-property property'" />

 <xsl:variable name="before" select="'application-ref'" />
 <xsl:variable name="after" select="'resource-ref system-property property'" />

 <xsl:template match="/">
      <xsl:apply-templates select="node()|@*"/>
  </xsl:template>
  <xsl:template match="node()|@*">
    <xsl:copy>
      <xsl:apply-templates select="node()|@*"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="virtual-server[@id!='__asadmin']">
    <xsl:copy>                    
      <xsl:copy-of select="@*"/>
      <xsl:element name="property">
        <xsl:attribute name="name">listener_1</xsl:attribute>
        <xsl:attribute name="value">org.jvnet.glassfish.comms.startup.SipServiceListener</xsl:attribute>
      </xsl:element>
      <xsl:element name="property">
        <xsl:attribute name="name">docroot</xsl:attribute>
        <xsl:attribute name="value">${com.sun.aas.instanceRoot}/docroot</xsl:attribute>
      </xsl:element>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="module-monitoring-levels">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:element name="property">
        <xsl:attribute name="name">sip-service</xsl:attribute>
        <xsl:attribute name="value">OFF</xsl:attribute>
      </xsl:element>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="module-log-levels">
    <xsl:copy>
      <xsl:apply-templates select="node()|@*"/>
      <xsl:element name="property">
        <xsl:attribute name="name">javax.enterprise.system.container.clb</xsl:attribute>
        <xsl:attribute name="value">INFO</xsl:attribute>
      </xsl:element>
      <xsl:element name="property">
        <xsl:attribute name="name">javax.enterprise.system.container.sip</xsl:attribute>
        <xsl:attribute name="value">INFO</xsl:attribute>
      </xsl:element>
      <xsl:element name="property">
        <xsl:attribute name="name">javax.enterprise.system.container.ar</xsl:attribute>
        <xsl:attribute name="value">INFO</xsl:attribute>
      </xsl:element>
      <xsl:element name="property">
        <xsl:attribute name="name">javax.enterprise.system.container.ssr</xsl:attribute>
        <xsl:attribute name="value">INFO</xsl:attribute>
      </xsl:element>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="http-listener">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="applications">
    <xsl:copy>
      <xsl:copy-of select="node()|@*"/>
      <xsl:element name="lifecycle-module">
        <xsl:attribute name="class-name">org.jvnet.glassfish.comms.startup.lifecycle.SipContainerLifecycle</xsl:attribute>
        <xsl:attribute name="classpath">${com.sun.aas.installRoot}/lib/comms-appserv-common.jar</xsl:attribute>
        <xsl:attribute name="enabled">true</xsl:attribute>
        <xsl:attribute name="is-failure-fatal">false</xsl:attribute>
        <xsl:attribute name="name">SipContainerLifecycle</xsl:attribute>
        <xsl:attribute name="object-type">system-all</xsl:attribute>
        <xsl:element name="description">"Sip Lifecycle Module"</xsl:element>
      </xsl:element>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="servers/server">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()[contains($before,name())]"/>
      <xsl:element name="application-ref">
        <xsl:attribute name="disable-timeout-in-minutes">30</xsl:attribute>
        <xsl:attribute name="enabled">true</xsl:attribute>
        <xsl:attribute name="lb-enabled">false</xsl:attribute>
        <xsl:attribute name="ref">SipContainerLifecycle</xsl:attribute>
      </xsl:element>
      <xsl:apply-templates select="@*|node()[contains($after,name())]"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="http-listener[@security-enabled='false']">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:element name="property">
        <xsl:attribute name="name">accesslog</xsl:attribute>
        <xsl:attribute name="value">${com.sun.aas.instanceRoot}/logs/access</xsl:attribute>
      </xsl:element>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="http-listener[@security-enabled='true']">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:element name="ssl">
        <xsl:attribute name="cert-nickname">s1as</xsl:attribute>
        <xsl:attribute name="ssl3-enabled">false</xsl:attribute>
      </xsl:element>
    </xsl:copy>
  </xsl:template>


  <xsl:template match="http-listener[@id='admin-listener']">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="http-file-cache">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="globally-enabled">false</xsl:attribute>
      <xsl:attribute name="file-caching-enabled">false</xsl:attribute>
    </xsl:copy> 
  </xsl:template>
  
  <xsl:template match="jmx-connector">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:element name="ssl">
        <xsl:attribute name="cert-nickname">s1as</xsl:attribute>
      </xsl:element>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="java-config">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="classpath-prefix">${com.sun.aas.installRoot}/lib/comms-appserv-rt.jar</xsl:attribute>
      <xsl:apply-templates select="node()"/>
      <xsl:element name="jvm-options">-Dcom.sun.enterprise.server.ss.ASQuickStartup=false</xsl:element>
      <xsl:element name="jvm-options">-Dsun.net.spi.nameservice.provider.1=dns,dnsjava</xsl:element>
      <xsl:element name="jvm-options">-Dcom.sun.appserv.pluggable.features=org.jvnet.glassfish.comms.server.pluggable.extensions.sip.SipPEPluggableFeatureImpl</xsl:element>
      <xsl:element name="jvm-options">-Dcom.sun.appserv.pluggable.extensions.amx=org.jvnet.glassfish.comms.admin.management.extensions.SIPAMXSupport</xsl:element>
      <xsl:element name="jvm-options">-DLifecycleModuleService.submitType=sync</xsl:element>
    </xsl:copy>
 </xsl:template>

  <xsl:template match="config">
    <xsl:copy>
      <xsl:apply-templates select="@*"/>
      <xsl:element name="sip-service">
        <xsl:copy-of select="http-service/access-log"/>
        <xsl:element name="sip-listener">
        <xsl:attribute name="id">sip-listener-1</xsl:attribute>
        <xsl:attribute name="address">0.0.0.0</xsl:attribute>
        <xsl:attribute name="port">%%%SIP_PORT%%%</xsl:attribute>
        <xsl:attribute name="transport">udp_tcp</xsl:attribute>
        <xsl:attribute name="enabled">true</xsl:attribute>
        </xsl:element>
        <xsl:element name="sip-listener">
        <xsl:attribute name="id">sip-listener-2</xsl:attribute>
        <xsl:attribute name="address">0.0.0.0</xsl:attribute>
        <xsl:attribute name="port">%%%SIP_SSL_PORT%%%</xsl:attribute>
        <xsl:attribute name="transport">tls</xsl:attribute>
        <xsl:attribute name="enabled">true</xsl:attribute>
        <xsl:element name="ssl">
          <xsl:attribute name="cert-nickname">s1as</xsl:attribute>
          <xsl:attribute name="ssl3-enabled">false</xsl:attribute>
        </xsl:element>
        </xsl:element>
        <xsl:element name="request-processing">
          <xsl:attribute name="header-buffer-length-in-bytes">8192</xsl:attribute>
          <xsl:attribute name="initial-thread-count">10</xsl:attribute>
          <xsl:attribute name="thread-count">10</xsl:attribute>
          <xsl:attribute name="thread-increment">1</xsl:attribute>
        </xsl:element>
        <xsl:element name="keep-alive">
          <xsl:attribute name="timeout-in-seconds">600</xsl:attribute>
        </xsl:element>
        <xsl:element name="connection-pool">
          <xsl:attribute name="max-pending-count">50</xsl:attribute>
        </xsl:element>
        <xsl:element name="sip-protocol">
          <xsl:attribute name="error-response-enabled">false</xsl:attribute>
          <xsl:attribute name="default-tcp-transport">false</xsl:attribute>
          <xsl:element name="sip-link">
            <xsl:attribute name="connection-alive-timeout-in-seconds">120</xsl:attribute>
            <xsl:attribute name="max-queue-length">50</xsl:attribute>
            <xsl:attribute name="write-timeout-in-millis">10</xsl:attribute>
            <xsl:attribute name="write-timeout-retries">25</xsl:attribute>
          </xsl:element>
          <xsl:element name="sip-timers">
            <xsl:attribute name="t1-in-millis">500</xsl:attribute>
            <xsl:attribute name="t2-in-millis">4000</xsl:attribute>
            <xsl:attribute name="t4-in-millis">5000</xsl:attribute>
          </xsl:element>
        </xsl:element>
          <xsl:element name="property">
            <xsl:attribute name="name">accesslog</xsl:attribute>
            <xsl:attribute name="value">${com.sun.aas.instanceRoot}/logs/sipaccess</xsl:attribute>
          </xsl:element>
        </xsl:element>

      <xsl:apply-templates select="@*|node()[contains($bf,name())]"/>
        <xsl:element name="sip-container">
          <xsl:attribute name="external-sip-port">%%%SIP_PORT%%%</xsl:attribute>
          <xsl:attribute name="external-sips-port">%%%SIP_SSL_PORT%%%</xsl:attribute>
          <xsl:element name="session-config">
            <xsl:element name="session-manager">
              <xsl:element name="manager-properties"/>
              <xsl:element name="store-properties"/>
            </xsl:element>
            <xsl:element name="session-properties"/>
          </xsl:element>
        </xsl:element>
      <xsl:apply-templates select="@*|node()[contains($af,name())]"/>

     </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
