/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.clb.admin;

import java.io.IOException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.admin.event.AdminEventListenerException;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerHelper;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.List;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.impl.SynchronizationClientImpl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jvnet.glassfish.comms.admin.event.extensions.clb.*;
import org.jvnet.glassfish.comms.util.LogUtil;

public class ConvergedLBEventListenerImpl implements ConvergedLbEventListener {
     static final String CONFIG = "config";
     static final String CLB_CONFIG_FILE="config-file";
    /**
     * Creates a new instance of ConvergedLBEventListenerImpl
     */
    public ConvergedLBEventListenerImpl() {
    }

    public void handleCreate(ConvergedLbEvent e) throws AdminEventListenerException
    {
        try{
          synchronizeCLBXml(e);
        }catch(SynchronizationException ex)
        {
            _logger.log(Level.SEVERE, "File Synchronization of converged-loadbalancer.xml with DAS failed " + ex.getMessage());
            throw new AdminEventListenerException(ex.getMessage());
        }
    }

    public void handleDelete(ConvergedLbEvent e) throws AdminEventListenerException
    {
         try{
          synchronizeCLBXml(e);
        }catch(SynchronizationException ex)
        {
            _logger.log(Level.SEVERE, "File Synchronization of converged-loadbalancer.xml with DAS failed " + ex.getMessage());
            throw new AdminEventListenerException(ex.getMessage());
        }
    }
    public void handleUpdate(ConvergedLbEvent e) throws AdminEventListenerException
    {
       try{
          synchronizeCLBXml(e);
        }catch(SynchronizationException ex)
        {
            _logger.log(Level.SEVERE, "File Synchronization of converged-loadbalancer.xml with DAS failed " + ex.getMessage());
             throw new AdminEventListenerException(ex.getMessage());
        }
    }
    protected void synchronizeCLBXml(ConvergedLbEvent e) throws SynchronizationException {
        // current server name
        String serverName=ApplicationServer.getServerContext().
                            getInstanceName();
        String[] clbXMLFileNames = getChangedConfigFilename(e, serverName);
        //Check if  Config file has changed. Else it is a no-op
        if (clbXMLFileNames == null) return ;
        String clbXMLFile = clbXMLFileNames[0];
        String oldXMLFileName = clbXMLFileNames[1];
        // connects to DAS
        String dasName = SystemPropertyConstants.DEFAULT_SERVER_INSTANCE_NAME;

        SynchronizationClientImpl sc = new SynchronizationClientImpl(dasName);

        _logger.log(Level.INFO,
                    "Start: Synchronizing CLB XML file from DAS. DAS NAME: " + dasName );
        try {
            sc.connect();
            _logger.log(Level.FINEST,
                    "Dynamic Reconfig: Successfully connected to DAS" );
        } catch (IOException ie) {
           throw new SynchronizationException("Connection to SynchronizationClientImpl failed. IOException occured while trying to connect " + ie.getMessage());
        }
        String instanceRoot = System.getProperty(SystemPropertyConstants.INSTANCE_ROOT_PROPERTY);

        String configName = getConfigName(e, serverName);

        String clbTargetLocation = instanceRoot + File.separator + CONFIG + File.separator + configName;

        //Added as a workaround for scenario when config-dir does not exist
        //under instance config
        final File clbTargetDir = new File(clbTargetLocation);
        if (!clbTargetDir.exists()) {
            try {
                AccessController.doPrivileged(new PrivilegedAction() {
                    public Object run() {
                        clbTargetDir.mkdir();
                        return null;
                    }
                });
            } catch (SecurityException ex) {
                throw new SynchronizationException(
                    "Unable to create directory " + clbTargetLocation, ex);
            }
        }
        
        _logger.log(Level.FINEST,
                    "Dynamic Reconfig: Fetching file from DAS. Source File - " + clbXMLFile + " Target Location - " + clbTargetLocation );

        sc.get(CONFIG + File.separator + configName + File.separator + clbXMLFile, clbTargetLocation + File.separator + clbXMLFile);

        _logger.log(Level.INFO,
                    "Synchronization completed sucessfully to " + clbTargetLocation);
        if(oldXMLFileName !=null)
        {
            try {
                _logger.log(Level.INFO,
                                   "Deleting the old DCR file- " + oldXMLFileName);

                    File oldCLBXMLFile= new File(clbTargetLocation + File.separator + oldXMLFileName);
                    boolean value = oldCLBXMLFile.delete();
                    if (value == false)
                        _logger.log(Level.WARNING, "Unable to delete " + oldXMLFileName);
            }catch(SecurityException se){
                  _logger.log(Level.WARNING, "Unable to delete " + oldXMLFileName + ". Error Message: " + se.getMessage());
            }
        }
        try {
            sc.disconnect();

        } catch (IOException ie) {
           throw new SynchronizationException("Unable to close connection to DAS");
        }
     _logger.log(Level.INFO,
                    "Reloading the configuration...");

     if(CLBConfigurator.getInstance() != null)
         CLBConfigurator.getInstance().reload(clbXMLFile);
    }

    /**
     * method to get the config name from the event's config context
     * @param e - the event
     * @param serverName
     * @return - the name of the Config from the config context. Else returns null
     */

    private String getConfigName(ConvergedLbEvent e, String serverName)
                throws SynchronizationException {
        ConfigContext _ctx = e.getConfigContext();
        try {
            if (_ctx == null ) {
                throw new RuntimeException("ConfigContext is null");
            }
            Config config = ServerHelper.getConfigForServer(_ctx,serverName);
            if (config == null ) {
                throw new RuntimeException("ServerHelper.getConfigForServer is null");
            }

            return config.getName();

        } catch (ConfigException ce) {
            throw new SynchronizationException("Unable to resolve configuration name");
        }

    }

    /**
     * method to check if the config file is one of the attributes that has changed.
     * @param e - the event
     * @param serverName
     * @return - the name of the Config file from the change list. Else returns null
     */
     private String[] getChangedConfigFilename(ConvergedLbEvent e, String serverName)
     {
         List changeList = e.getConfigChangeList();
         String[] clbConfigFileNames = null;
         for (int i =0; i < changeList.size(); i++)
        {
                ConfigChange change = (ConfigChange) changeList.get(i);

                 if (change!= null && change instanceof ConfigUpdate)
                 {
                      clbConfigFileNames = new String[2];
                      clbConfigFileNames[0]= ((ConfigUpdate)change).getNewValue(CLB_CONFIG_FILE);
                      clbConfigFileNames[1]= ((ConfigUpdate)change).getOldValue(CLB_CONFIG_FILE);
                     _logger.log(Level.INFO, "CLB Config File name in the change list - " + clbConfigFileNames[0]);
                      return clbConfigFileNames;

                }
        }
         return null;
     }
    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();

}
