/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core;


/**
 *
 * @author kshitiz
 */
public final class CLBConstants {
    /* boolean indicating that this is http component of converged load balancer */
    public static final int HTTP_CLB = 0;

    /* boolean indicating that this is sip component of converged load balancer */
    public static final int SIP_CLB = 1;

    /* prefix of http listener */
    public static final String HTTP_PROTOCOL = "http://";

    /* prefix of https listener */
    public static final String HTTPS_PROTOCOL = "https://";

    /* prefix of sip listener */
    public static final String SIP_PROTOCOL = "sip://";

    /* prefix of sips listener */
    public static final String SIPS_PROTOCOL = "sips://";

    /* default http port */
    public static final int DEFAULT_HTTP_PORT = 80;

    /* default https port */
    public static final int DEFAULT_HTTPS_PORT = 443;

    /* default sip port */
    public static final int DEFAULT_SIP_PORT = 5060;

    /* default sips port */
    public static final int DEFAULT_SIPS_PORT = 5061;

    /* BERoute key name */
    public static final String BEROUTE_KEY_NAME = "BERoute";

    /* BEkey key name */
    public static final String BEKEY_KEY_NAME = "BEKey";

    /* proxy header for BERoute key*/
    public static final String PROXY_HEADER_BEROUTE_KEY = "proxy-beroute";

    /* proxy header for BEkey key*/
    public static final String PROXY_HEADER_BEKEY_KEY = "proxy-bekey";

    /* module name of the converged load-balancer */
    public static final String MODULE_NAME = "CLB";

    /* cookie header in http request */
    public static final String COOKIE_HEADER = "Cookie";

    /* default context root */
    public static final String DEFAULT_CONTEXT_ROOT = "/";

    /** BEKey regex that would be checked against in the request URI.
     *  This is used to check if route info is encoded in the URI.
     */
    public static final String BEKEY_URI_IDENTIFIER =
                                               ";" + BEKEY_KEY_NAME + "=";

    /** BERoute regex that would be checked against in the request URI.
     *  This is used to check if route info is encoded in the URI.
     */
    public static final String BEROUTE_URI_IDENTIFIER =
                                              ";" + BEROUTE_KEY_NAME + "=";

    /** Comma delimiter for encoded identifiers */
    public static final String COMMA_DELIMITER = ";";

    /** Creates a new instance of CLBConstants */
    public CLBConstants() {
    }
}
