/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import javax.servlet.sip.SipServletRequest;


/**
 * A request used in the consistent hash based routers.
 */
public class ConsistentHashRequest {
    private SipServletRequest sipRequest;
    private HttpRequest httpRequest;
    private String hashKey;
    private boolean isHttp;

    /**
     * Creates an instance.
     * @param request the sip request
     * @param hashKey an already extracted hash key
     *
     */
    public ConsistentHashRequest(SipServletRequest request, String hashKey) {
        this.sipRequest = request;
        this.hashKey = hashKey;
        this.isHttp = false;
    }

    /**
    * Creates an instance.
    * @param request the http request
    * @param hashKey an already extracted hash key
    */
    public ConsistentHashRequest(HttpRequest request, String hashKey) {
        this.httpRequest = request;
        this.hashKey = hashKey;
        this.isHttp = true;
    }

    /**
     * Gets the request as HTTP.
     * @return the the request as HTTP
     */
    public HttpRequest getHttpRequest() {
        return httpRequest;
    }

    /**
     * Gets the request as SIP.
     * @return the the request as SIP
     */
    public SipServletRequest getSipRequest() {
        return sipRequest;
    }

    /**
     * Gets the hash key
     * @return the hashKey
     */
    public String getHashKey() {
        return hashKey;
    }

    /**
     * Sets the hash key.
     * @param hashKey the hash key
     */
    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    /**
     * Check if the request is an HTTP or SIP request
     * @return true = HTTP; false = SIP
     */
    public boolean isHttp() {
        return isHttp;
    }
}
