/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 *
 * @author kshitiz
 */
public abstract class ControllerInitializer {
    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();
    protected Controller controller;

    /* Creates a new instance of ControllerInitializer */
    public ControllerInitializer() {
        controller = null;
    }

    /**
     * This method is called by AdminService to create an instance of Controller
     *
     * @return a new controller instance
     */
    public Controller createController() {
        Controller newController = Controller.createInstance();

        return newController;
    }

    /**
     * This method is called to get controller associated with this instance
     *
     * @return the controller associated with this instance
     */
    public Controller getController() {
        return controller;
    }
    
    /**
     * This method is called by AdminService a new controller. On this new controller, admin
     * has already created cluster, instance and request group. A reconfig is performed and then
     * new controller is initialized. The current controller is replaced by new controller. And clean
     * up is performed on old controller
     *
     * @param newController the new controller instance
     */
    public void setController(Controller newController)
        throws CLBRuntimeException {
        if (controller != null) {
             if(_logger.isLoggable(Level.FINE))
                 _logger.log(Level.FINE,
                         "clb.reconfiguring_new_controller");
            newController.reconfig(controller);
        }

         if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.initializing_new_controller");
        newController.initialize();

        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.setting_new_controller_in_LBM");
        
        Controller oldController = controller;
        controller = newController;

        if (oldController != null) {
             if(_logger.isLoggable(Level.FINE))
                 _logger.log(Level.FINE,
                         "clb.cleaning_up_old_controller");
            oldController.cleanUp();
        }
    }
}
