/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core;

import com.sun.grizzly.util.buf.MessageBytes;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.util.Map;

import javax.servlet.http.Cookie;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 *
 * @author kshitiz
 */
public class StickyBERouteKeyExtractor {
    
    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();

    /**
     * Get the BERoute key from the request.  This key uniquely identifies the back-end instance.
     *
     * @param req the request
     *
     * @return the BERoute key if present, else return null
     */
    public static String getBERouteKey(HttpRequest request) {
        String value = null;
        MessageBytes uriMB = request.requestURI();
        String requestURI = uriMB.toString();

        if(_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE,
                        "clb.search_encodedURL_route",
                        new Object[]{CLBConstants.BEROUTE_KEY_NAME,
                                     requestURI
                                    });
        }
        
        //search URL for encoded route
        value = extractBERouteFromURI(requestURI);
        if (value != null) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO,
                            "clb.found_route_encodedURL",
                             new Object[] {CLBConstants.BEROUTE_KEY_NAME,
                                           value, requestURI
                                          });
            }
            return value;
        }

        //search the cookies
        if(_logger.isLoggable(Level.FINE))
            _logger.log(Level.FINE,
                    "clb.looking_for_cookie",
                    new Object[]{CLBConstants.BEROUTE_KEY_NAME});
        String cookieString = request.getHeader(CLBConstants.COOKIE_HEADER);

        if ((cookieString == null) || (cookieString.length() == 0)) {
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.req_does_not_have_cookie",
                        new Object[]{CLBConstants.BEROUTE_KEY_NAME});
            return null;
        }

        int index = cookieString.indexOf(CLBConstants.BEROUTE_KEY_NAME);

        if (index == -1) {
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.req_does_not_have_cookie",
                        new Object[]{CLBConstants.BEROUTE_KEY_NAME});
            return null;
        }

        int valueStartIndex = cookieString.indexOf("=", index + 1);

        if (valueStartIndex == -1) {
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.req_does_not_have_cookie",
                        new Object[]{CLBConstants.BEROUTE_KEY_NAME});
            return null;
        }

        String cookieValue = null;
        int valueEndIndex = cookieString.indexOf(";", valueStartIndex + 1);

        if (valueEndIndex == -1)
            valueEndIndex = cookieString.indexOf(",", valueStartIndex + 1);

        if (valueEndIndex == -1)
            cookieValue = cookieString.substring(valueStartIndex + 1);
        else
            cookieValue =  cookieString.substring(valueStartIndex + 1, valueEndIndex);
        
        if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.found_cookie_with_value",
                        new Object[]{CLBConstants.BEROUTE_KEY_NAME, cookieValue});
        return cookieValue;
    }

    /**
     * Extract the encoded BERoute from the requestURI.
     * @param requestURI The Http request URI
     *
     * @return BERoute value if found otherwise null.
     */
    private static String extractBERouteFromURI(String requestURI) {
        String extractedBERoute = null;

        try {
            int startIndexForBERoute = requestURI.indexOf(
                                         CLBConstants.BEROUTE_URI_IDENTIFIER);
            if (startIndexForBERoute != -1) {
                //Found BERoute URL encoded.
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE,
                                "clb.retrieving_URLencoded_route",
                                 new Object[] {CLBConstants.BEROUTE_KEY_NAME,
                                               requestURI
                                              });
                }
                                   
                int startIndexForBERouteValue = startIndexForBERoute
                               + CLBConstants.BEROUTE_URI_IDENTIFIER.length();
                int startIndexForNextID = requestURI.indexOf(
                                                CLBConstants.COMMA_DELIMITER,
                                                startIndexForBERouteValue);


                if (startIndexForNextID != -1) {
                    //There are more id's encoded; extract BERoute
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE,
                                    "clb.multiple_URLencoded_IDs",
                                    new Object[]{CLBConstants.BEROUTE_KEY_NAME,
                                                 requestURI
                                                });
                    }

                    extractedBERoute = requestURI.substring(
                                                   startIndexForBERouteValue,
                                                   startIndexForNextID);
                } else {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE,
                                    "clb.zero_URLencoded_IDs_after_route",
                                    new Object[]{CLBConstants.BEROUTE_KEY_NAME,
                                                 requestURI
                                                });
                    }

                    extractedBERoute = requestURI.substring(
                                                   startIndexForBERouteValue);
                }

                return (extractedBERoute.trim());
            }
        } catch (IndexOutOfBoundsException ex) {
              if (_logger.isLoggable(Level.SEVERE)) {
                  _logger.log(Level.SEVERE,
                              "clb.error_extract_route_encodedURL",
                              new Object[] {CLBConstants.BEROUTE_KEY_NAME,
                                            requestURI
                                           }); 
                 _logger.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
              }
        }

        return extractedBERoute;
    }
}
