/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.util.List;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 *
 * @author kshitiz
 */
public class StickyRoundRobinRouter extends RoundRobinRouter {
    
    private static final Logger _logger = LogUtil.CLB_LOGGER.getLogger();

    /** Creates a new instance of StickyRoundRobinRouter */
    public StickyRoundRobinRouter(List<ServerCluster> clusters,
        boolean activeRouting) {
        super(clusters, activeRouting);
    }

    public ServerInstance selectInstance(HttpRequest req) {
        String beRoute = StickyBERouteKeyExtractor.getBERouteKey(req);
        ServerInstance instance = null;

        if (beRoute != null) {
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.found_key_in_request",
                        new Object[]{CLBConstants.BEROUTE_KEY_NAME, beRoute});
            
            //select an instance using BERoute key and assign it to instance
            instance = controller.getGlobalInstanceMap()
                                 .getServerInstance(beRoute);

            if (instance != null) {
                if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.instance_found_for_key",
                        new Object[]{instance.getName(), beRoute, instance.isHealthy(),
                        instance.isEnabled(), instance.isQuiesced()});
                /* Need to select another instance from cluster in below cases
                 * 1. Instance is unhealthy
                 * 2. Instance is disabled as well as quiesced
                 */
                if (!instance.isHealthy() ||
                        (instance.isDisabled() && instance.isQuiesced())) {
                    //select another instance from cluster
                    if(_logger.isLoggable(Level.FINE))
                        _logger.log(Level.FINE,
                                "clb.looking_for_instance_in_cluster",
                                new Object[]{instance.getName()});
                    instance = instance.getServerCluster().getClusterRouter()
                                       .selectInstance(req);
                }
            }
        }

        //if no instance is found, select any active instance
        if (instance == null) {
            if(_logger.isLoggable(Level.FINE))
                _logger.log(Level.FINE,
                        "clb.looking_for_active_instance");
            instance = getActiveInstance();
        }

        return instance;
    }
}
