/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.core.util;

import org.apache.catalina.util.Base64;

import org.jvnet.glassfish.comms.clb.core.CLBRuntimeException;

import java.net.InetAddress;
import java.net.UnknownHostException;


/**
 *
 * @author kshitiz
 */
public class IDGenerator {
    private static final int DEFAULT_PORT = 88888;

    // array of 251 random values
    private static final int[] obfuscate = {
            0xe914d02e, 0x56a53780, 0xb25567ca, 0xe2424d51, 0x845fd790,
            0x609faeb2, 0x09dcb729, 0x986fbd6e, 0x26b1417a, 0x79a84c74,
            0x5f62d289, 0x3d844bfb, 0xc805c8df, 0x3f3828c3, 0x7cbf5d03,
            0x497bf192, 0x13d9471f, 0xbe469913, 0xcf684616, 0x0019f018,
            0x6cf32b5d, 0x83c53320, 0xdc635b63, 0xfd21862d, 0x0a002abb,
            0x37be013f, 0x8eebcbd4, 0x0bf6e96f, 0x235cf832, 0xb36755b1,
            0x9590cd65, 0xcef06b9f, 0xc4ba8238, 0xde23fcfe, 0xcb64ea11,
            0x1724f501, 0xcc6baf88, 0xc5518036, 0x0ed3def4, 0x2b77689e,
            0xf01773e2, 0xd08bb54a, 0xf6ce9378, 0x7869dfd3, 0x580158e1,
            0x118c0498, 0xd1e09cf1, 0x75c86958, 0xaaa04fc2, 0xf1c97dd7,
            0x1f4d8302, 0x51d08daf, 0x03395910, 0xfbe3138c, 0xafeae1cb,
            0xf918231c, 0xff2cbfaa, 0xdfb66326, 0x76ca8b43, 0x50850241,
            0xc6b3a0ae, 0xe5edcfd5, 0x87801a12, 0xa9862e79, 0xc73cf2e9,
            0x865ee33d, 0xa3d126fa, 0x5292911a, 0x36156a94, 0xe63d9e23,
            0x27e1574b, 0x7a060dde, 0x186da57b, 0xf78fa1e0, 0xaea2c206,
            0x7b4506e4, 0x3a1dd3c7, 0xecd690cd, 0x2df9b64c, 0xb73f7744,
            0xc9c27e04, 0x65786e4e, 0xb6e81fa1, 0xa46a6fc5, 0xd471d9db,
            0x9443fbee, 0x1987d619, 0xcacb84a0, 0x34a10a3a, 0x0859d422,
            0xa54fa7c4, 0x6bb8549c, 0x0f82341d, 0xc2dae7d8, 0x15319d0f,
            0xac5831ba, 0x5b330f0a, 0x0d6c568b, 0x451c0c2a, 0x449b10e7,
            0xf370c797, 0x3b93c05a, 0x9e9666a3, 0x9b7924d9, 0x471af652,
            0x411112c1, 0x81b0ce6d, 0x1e7df73e, 0x3ce2ac4d, 0x97f17946,
            0x694e1ec8, 0xfc5452f0, 0x610b7534, 0xe87215a4, 0xc188a885,
            0xe38300a5, 0x8fc02935, 0xb1761499, 0x1a26bc57, 0xd7fc1b00,
            0x43098ff7, 0xb41343c0, 0x6fdec127, 0xe03e198d, 0x8957ed4f,
            0x64346564, 0x353b4aad, 0x6781180e, 0x2eadabed, 0xc3d2217d,
            0xf2758567, 0x22ddbeff, 0x1dcc765b, 0x389ad15c, 0x3297fa73,
            0x1cbc53e3, 0xd3e992bc, 0x1ba9ec1e, 0x30229a33, 0xed9805b4,
            0x59aa7221, 0x6e30d525, 0x66364568, 0x0cb2c57e, 0x061bb261,
            0xd820fdb7, 0x1050f4dc, 0xbfec4981, 0xcdfd7a49, 0xeff52777,
            0x96443b9a, 0x57603242, 0x8a350795, 0x63b7ef60, 0x2c03ff50,
            0x8cf22fac, 0xd9faadb3, 0x42e67140, 0xeeefe0ab, 0x2a49cad0,
            0x217a2096, 0xe1280891, 0x04d8b993, 0x5d5dc372, 0xbdc7b17f,
            0x9f2ab0f2, 0xe747817c, 0x205b396a, 0x4ad47870, 0x9cff96bf,
            0x808e5ebd, 0xd59cba09, 0xba2b7cb5, 0xab89e437, 0xc09161b9,
            0x70b5a662, 0x12cf3c54, 0x685a7424, 0x71087bd1, 0xdb9e0e53,
            0xf8b997ea, 0x7274eb07, 0x5e40b88a, 0x91c35c84, 0xadc48c6c,
            0x333260a7, 0xebc1e6b0, 0x311ea469, 0x6d53c4fc, 0x28ae3fef,
            0x2f6ee20b, 0x77733da9, 0x622e7fce, 0x82a63814, 0x07df1c3c,
            0x5c61f92f, 0x540e6408, 0xa7cd70c6, 0xf4fb89fd, 0xbce7113b,
            0x93125fc9, 0x6a48628f, 0xda656c56, 0x88f8c9b6, 0xa2251717,
            0x2910508e, 0x73ac48e8, 0x24f49fe6, 0x01416d55, 0x7dafee0d,
            0x489d2cd2, 0x7e99a939, 0x4e02bba8, 0x55a49486, 0x7456b382,
            0xfe0495cf, 0xb5dbdb71, 0x904b8783, 0xf5bdddf8, 0x9afe3e5f,
            0xd6944e0c, 0xa8e45a47, 0xeaeee5a6, 0x8bf7b41b, 0xdd4c446b,
            0x407f51d6, 0x5a4a9866, 0xb8ab83dd, 0xd227e8cc, 0x2552fef6,
            0x8da325e5, 0xbb8a30f5, 0x997c3531, 0x140a3a05, 0xe4d54248,
            0xfabb03ec, 0xa1a736f3, 0x02d79beb, 0x391fa29d, 0x05162dda,
            0x163af375, 0x4db4da2c, 0x3ee52230, 0x4b66aa45, 0x8595a328,
            0x4c0fc6be, 0x922d8887, 0xb0c6dc5e, 0xb937ccb8, 0x467e1d15,
            0xa02f8a9b
        };

    /** Creates a new instance of IDGenerator */
    public IDGenerator() {
    }

    public static String getId(String hostName, String clusterName,
        String instanceName) throws CLBRuntimeException {
        long hash = 0x000000ceL;
        hash = hostPortHash(hash, DEFAULT_PORT, hostName);
        hash = stringHash(hash, clusterName + instanceName);

        return generateHashCode(hash);
    }

    public static String getId(String hostName, int port, boolean flagSecure)
        throws CLBRuntimeException {
        long hash = 0x000000ceL;
        hash = hostPortHash(hash, port, hostName);

        // Use SSL configuration information
        if (flagSecure) {
            hash = (~hash) & 0xFFFFFFFFL;
        }

        return generateHashCode(hash);
    }

    private static String generateHashCode(long hash) {
        // Distribute entropy across entire hash value
        int index = (int) (hash % (obfuscate.length / 4));
        hash = (hash ^ obfuscate[index]) & 0xFFFFFFFFL;

        // Mod of prime closest to 2^24 distributes entropy across low 24 bits
        hash = hash % 16777259;

        // Only use bottom 24 bits (3 bytes, 4 base 64 characters)
        hash = hash & 0x00ffffff;

        byte[] generatedHash = Base64.encode(intToByteArray(hash));

        return new String(generatedHash);
    }

    private static long hostPortHash(long hash, final int port,
        final String hostName) throws CLBRuntimeException {
        byte[] address = null;

        try {
            address = InetAddress.getByName(hostName).getAddress();
        } catch (UnknownHostException ex) {
            throw new CLBRuntimeException("Unknown host (" + hostName +
                ") specified as host name ", ex);
        }

        long ip;
        long portLong;
        long first;
        long second;
        long third;
        long fourth;

        // Use IP and port
        if (address.length == 4) {
            ip = getValue(address, 0);
            hash = (hash ^ ip) & 0xFFFFFFFFL;
            portLong = (long) (port << 16);
            hash = (hash ^ portLong) & 0xFFFFFFFFL;
        } else if (address.length == 16) {
            ip = getValue(address, 0);
            hash = (hash ^ ip) & 0xFFFFFFFFL;
            ip = getValue(address, 4);
            hash = (hash ^ ip) & 0xFFFFFFFFL;
            ip = getValue(address, 8);
            hash = (hash ^ ip) & 0xFFFFFFFFL;
            ip = getValue(address, 12);
            hash = (hash ^ ip) & 0xFFFFFFFFL;
            portLong = (long) (port << 16);
            hash = (hash ^ portLong) & 0xFFFFFFFFL;
        } else {
            throw new CLBRuntimeException("Unknown address format");
        }

        return hash;
    }

    /**
     * Covert lower 24 bits of long passed into a byte array of size 3
     *
     * @param value long to be coverted to byte array
     */
    private static final byte[] intToByteArray(long value) {
        return new byte[] {
            (byte) ((value >> 16) & 0xff), (byte) ((value >> 8) & 0xff),
            (byte) (value & 0xff)
        };
    }

    private static final long getValue(byte[] addrArray, int index) {
        long finalValue = 0;

        for (int i = 0; i < 4; i++) {
            if ((index + i) >= addrArray.length) {
                break;
            }

            int value = (0x000000FF & ((int) addrArray[index + i]));
            finalValue = (finalValue << 8) + value;
        }

        return finalValue;
    }

    private static long stringHash(long hash, String name) {
        if ((name == null) || (name.length() == 0)) {
            return hash;
        }

        byte[] nameBytes = name.getBytes();
        int index = 0;

        for (byte nameByte : nameBytes) {
            long i = ((0x000000FF & ((int) nameByte)) * (nameBytes.length -
                index));
            index++;
            hash = ((hash ^ i) & 0xFFFFFFFFL);
        }

        return hash;
    }
}
