
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.clb.plugin;

import java.util.Map;

/**
 * An event that characterizes a change in the cluster configuration.
 * The change is limited to instances joining the cluster and instances shutting down
 */


public class ClusterConfigChangeEvent {

    public static final int JOIN_EVENT = 2;
    public static final int SHUT_DOWN_EVENT = 3;


    private int eventType = -1;
    private String clusterName = null;
    private String memberToken = null;
    private Map memberDetails = null;

    /**
     * Method to get the event type corresponding to this event - One of JOIN_EVENT or SHUT_DOWN_EVENT
     * @return event type
     */

    public int getEventType(){
        return eventType;
    }

     /**
     * Method to set event type for this event
     * @param type - Event type corresponding to this event -  One of JOIN_EVENT or SHUT_DOWN_EVENT
     */

    protected void setEventType(int type)
    {
         this.eventType = type;
    }

   /**
     * Method to get the Member (instance) details
     * @return Map of member details
     */

    public Map getMemberDetails(){
           return memberDetails;
    }
     /**
     * Method to set the Member (instance) details
     * @param details- a Map of member (instance) details corresponding to this event
     */

    protected void setMemberDetails(Map details)
    {
        memberDetails = details;
    }

    /**
     * Method returns the Cluster name to which the event corresponds.
     * @return cluster name
     */
    public String getClusterName(){
         return clusterName;
    }

    /**
     * Method to set the Cluster name where the event occured
     * @param clusterName - Name of the cluster corresponding to this event
     */

    protected void setClusterName(String clusterName)
    {
        this.clusterName = clusterName;
    }

    /**
      * Method to get the Member token for the intance corresponding to this event
      * @return the member token for this instance
      */

    public String getMemberToken(){
         return memberToken;
    }

    /**
      * Method to set the member token of the instance to which this event occured
      * @param token - Member token of the instance corresponding to this event
      */

    protected void setMemberToken(String token)
    {
        memberToken = token;
    }
}
