/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy;


import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;

import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.http.layers.LoadBalancerLayer;
import org.jvnet.glassfish.comms.clb.proxy.http.layers.ParserLayer;
import org.jvnet.glassfish.comms.httplayers.HttpLayer;
import org.jvnet.glassfish.comms.httplayers.HttpLayerHandler;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author
 */
public class ProxyLayerHandler {
    private Logger _logger;
    
    /**
     * Creates a new instance of ProxyLayerHandler
     */
    public ProxyLayerHandler() {
        _logger = ProxyConfig.getInstance().getLogger();
        addBasicLayer(new ParserLayer());
        if (ProxyConfig.getInstance().isTestMode()){
            addLayer(new LoadBalancerLayer());
        }
    }
    
    public void doInvoke(Request request, Response response) {
        List<HttpLayer> layers = HttpLayerHandler.getInstance().getLayers();
        
        if (layers.size() > 0) {
            boolean status = true;
            int i;
            
            for (i = 0; i < layers.size(); i++) {
                try {
                    HttpLayer layer = (HttpLayer) layers.get(i);
                    
                    if (_logger.isLoggable(Level.FINE)){
                        _logger.log(Level.FINE,
                                "clb.proxy.before_invoking_layer", layer.getClass().getName());
                    }
                    status = layer.invoke(request, response);
                    if (_logger.isLoggable(Level.FINE)){
                        _logger.log(Level.FINE,
                                "clb.proxy.after_invoking_layer", layer.getClass().getName());
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                    response.setStatus(500);
                    status = false;
                }
                
                if (!status) {
                    break;
                }
            }
        } else {
            _logger.log(Level.SEVERE, "clb.proxy.no_layers");
        }
    }
    
    public void addLayer(HttpLayer nextlayer) {
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.adding_layer" +
                    nextlayer.getClass().getName());
        }
        HttpLayerHandler.getInstance().addLayer(nextlayer);
    }
    
    public void addLayers(List<HttpLayer> layers) {
        for (HttpLayer layer : layers) {
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE, "clb.proxy.adding_layer" +
                        layer.getClass().getName());
            }
            HttpLayerHandler.getInstance().addLayer(layer);
        }
    }
    
    public void addBasicLayer(HttpLayer layer) {
        HttpLayerHandler.getInstance().addBasicLayer(layer);
    }
    
    public int layerCount() {
        return HttpLayerHandler.getInstance().getLayers().size();
    }
}
