/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.config;

import com.sun.grizzly.util.buf.ByteChunk;


/**
 *
 * @author rampsarathy
 */
public final class LoadBalancerProxyConstants {
    /**
     * Content length header
     */
    public static final String CONTENT_LENGTH = "content-length";
    
    /**
     * Converged proxy header
     */
    public static final String HTTP_PROXY_HEADER = "felb";
    
    /**
     * Default read timeout for socket read
     */
    public static final int DEFAULT_READ_TIMEOUT = 30000;
    
    /**
     * Default HTTP header buffer size.
     */
    public static final int DEFAULT_HTTP_HEADER_BUFFER_SIZE = 8 * 1024;
    
    /**
     * CRLF.
     */
    public static final String CRLF = "\r\n";

    /**
     * Connection header.
     */
    public static final String HTTP_CONNECTION_HEADER = "Connection";
    /**
     * Connection close value.
     */
    public static final String HTTP_CONNECTION_CLOSE_VALUE = "close";
    /**
     * domain.xml attributes.
     */
    /**
     * Clb module name
     */
    private static final String PACKAGE_NAME = "clb";
    /**
     * Default log level
     */
    public static final String DEFAULT_LOG_LEVEL = "INFO";
    /**
     * Http request Pool size.
     */
    public static final int HTTP_PAYLOAD_POOL_SIZE = 10;
    /**
     * Https request pool size.
     */
    public static final int HTTPS_PAYLOAD_POOL_SIZE = 10;
    /**
     * SSL input buffer size.
     */
    public static final int DEFAULT_INPUTBB_SIZE = 5 * 4096;
    /**
     * Maximum retries for send to remote instance.
     */
    public static final int MAX_SEND_RETRY = 3;
    
    public static final String HTTP_11 = "HTTP/1.1 ";
    
    public static final byte[] HTTP_11_BYTES =
            ByteChunk.convertToBytes(HTTP_11);
    
    public static final int SSL_HEADER_SIZE = 1024;
    
    protected static final String END = "0\r\n\r\n";
    
    public static final byte[] END_BYTES =
            ByteChunk.convertToBytes(END);
    
    public static final String CERT_HEADER = "Proxy-auth-cert";
    
    public static final String CONTENT_LENGTH_HEADER = "Content-length";
    
    public static final String CONTENT_TYPE_HEADER = "Content-type";
    
    public static final String SERVER_HEADER = "Server";
    
    public static final byte [] CERT_HEADER_BYTES =
            ByteChunk.convertToBytes(CERT_HEADER);
    
    public final static byte[] TE_HEADER = "transfer-encoding".getBytes();   
    
    public static final int RECEIVE_ATTEMPTS = 10;    
    
    public static final int MAX_HEADER_BUFFER_SIZE = 4*DEFAULT_HTTP_HEADER_BUFFER_SIZE;
    
    public static final String SERVICE_UNAVAILABLE = "Service Unavailable";    
    
    /* Improvement , could be read from an error file
     */
    public static final String SERVICE_UNAVAILABLE_MESSAGE = 
            "<html><head><title>503 Service Unavailable</title>" +
            "</head><body><h1>Resource is not available, please try later</h1>" +
            "</body></html>" ;
    
    public final static byte[] SERVICE_UNAVAILABLE_BYTES = SERVICE_UNAVAILABLE_MESSAGE.getBytes();
    
    public final static int SERVICE_UNAVAILABLE_LENGTH = SERVICE_UNAVAILABLE_BYTES.length;
    
    public static final int REQUEST_POLL_TIMEOUT = 30;
    
}
