/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.http;

import com.sun.enterprise.web.portunif.*;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;

import org.jvnet.glassfish.comms.clb.proxy.ProxyRequestHandler;
import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.http.util.ObjectManager;
import org.jvnet.glassfish.comms.clb.proxy.portunif.ClbProxyProtocolInfo;

import java.io.IOException;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * A <code>ProtocolFinder</code> implementation that parse the available
 * SocketChannel bytes looking for the 'http' bytes.
 *
 * @author
 */
public class LoadBalancerProxyFinder extends HttpProtocolFinder {
    private Logger _logger = null;
    private ObjectManager objManager;
    private TlsProtocolFinder tlsfinder;
    
    public LoadBalancerProxyFinder() {
        objManager = ObjectManager.getInstance();
        objManager.initialize();
        _logger = ProxyConfig.getInstance().getLogger();
        tlsfinder = new TlsProtocolFinder();
    }
    
    /**
     * Try to find if the current connection is using the HTTP protocol.
     * Also if the protocol is Http, this class determines if the
     * request has to be served by the local web container or by a remote
     * instance.
     *
     * @param ProtocolInfo The ProtocolInfo that contains the information
     *                      about the current protocol.
     */
    public void find(ProtocolInfo protocolInfo) {
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.http.finder_invoked");
        }
        if (protocolInfo.isRequestedTransportSecure) {
            try {
                tlsfinder.find(protocolInfo);
            } catch (IOException ex) {
                _logger.log(Level.SEVERE,"clb.proxy.http.finder_tls_exception", ex);
            }
        }
        super.find(protocolInfo);
        if (protocolInfo.protocol != null) {
            if (protocolInfo.protocol.equals("http") ||
                    protocolInfo.protocol.equals("https")) {
                if (isRemoteTermination(protocolInfo)) {
                    protocolInfo.protocol = protocolInfo.isSecure ? "lb/https"
                            : "lb/http";
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE,        
                "clb.proxy.finder_result",""  + protocolInfo.protocol); 
        }
    }
    
    private boolean isRemoteTermination(ProtocolInfo protocolInfo) {
        try {
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE,"clb.proxy.polling_task");
            }
            ProxyRequestHandler task = objManager.pollTask(protocolInfo.isSecure);
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE,"clb.proxy.polled_task", "" + task);
            }            
            task.setByteBuffer(protocolInfo.byteBuffer);
            task.setSelectionKey(protocolInfo.key);
            task.setSecure(protocolInfo.isSecure);
            task.setSSLEngine(protocolInfo.sslEngine);
            task.setOutputBB(protocolInfo.outputBB);
            task.doTask();
            protocolInfo.inputBB = task.getBuffer();
            protocolInfo.bytesRead = task.getBuffer().position();
            protocolInfo.byteBuffer = task.getBuffer();
            Endpoint remoteHost = task.getEndpoint();
            
            /**
             *  Possible conditions 
             * 1. Endpoint is null and the layer execution
             * completed (without any layer returning false).
             * In this case pass it on to the local container.
             * 2. Endpoint is null and one of the layers failed
             * and set a response code != 200, then we send back
             * an error response through the handler.
             * 3. Endpoint is not null and is a local one then pass
             * it on to container.
             * 4. Endpoint is not null and is a remote one, then proxy
             * it.
             * Assumption: If a layer fails (returns false), then it
             * will set a proper http status code in response
             */
            if (remoteHost == null) {
                if (task.getResponse().getStatus() == 200) {
                    _logger.log(Level.INFO, "clb.proxy.request_endpoint_null_200");
                    task.recycle();
                    objManager.offerTask(task, protocolInfo.isSecure);
                    return false;
                } else {
                    _logger.log(Level.INFO, "clb.proxy.request_endpoint_null");
                }
            } else if (remoteHost.isLocal()) {
                _logger.log(Level.INFO, "clb.proxy.request_local");
                task.recycle();
                objManager.offerTask(task, protocolInfo.isSecure);
                return false;
            } else {
                _logger.log(Level.INFO, "clb.proxy.request_remote");
            }
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE,
                        "clb.proxy.http.protocolinfo_bytes_read","" + protocolInfo.bytesRead);
                _logger.log(Level.FINE, "clb.proxy.requesthandler.payload_length", "" +
                        task.getPayloadLength());
            }
            ((ClbProxyProtocolInfo) protocolInfo).object = task;
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        return true;
    }
}
