/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.http.layers;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;

import org.jvnet.glassfish.comms.clb.proxy.DefaultEndpoint;
import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.LoadBalancerProxyConstants;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.config.RoundRobinPolicy;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.jvnet.glassfish.comms.httplayers.HttpLayer;


import java.net.InetSocketAddress;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * This class is used for standalone testing of proxy. This is not meant for
 * use in production.
 *
 * @author rampsarathy
 */
public class LoadBalancerLayer implements HttpLayer {
    Logger _logger = null;
    
    /** Creates a new instance of LoadBalancerLayer */
    public LoadBalancerLayer() {
        _logger = ProxyConfig.getInstance().getLogger();
    }
    
    public boolean invoke(Request request, Response response)
    throws Exception {
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.test.loadbalancerlayer_begin");
        }
        HttpRequest httpReq = (HttpRequest) request;
        Endpoint remoteEndpoint = null;
        boolean ret = true;
        if (request.getHeader("ERRORTEST") != null) {
            response.setHeader("TESTHEADER", "ProxyTest");
            response.setErrorURI("testurl");
            response.setStatus(500);
            response.setMessage("Internal Server Error");
            _logger.log(Level.INFO, "clb.proxy.test.error_response");
            return false;
        }
        if ((httpReq.getHeader(LoadBalancerProxyConstants.HTTP_PROXY_HEADER) != null)) {
            Endpoint ep = new DefaultEndpoint();
            ep.setLocal(true);
            httpReq.setConvergedLoadBalancerEndpoint(ep);
            return false;
        }
        InetSocketAddress remoteHost = RoundRobinPolicy.getInetSocketAddress(request);
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE,"clb.proxy.test.remote_host", remoteHost);
        }
        if (remoteHost.getAddress().isLoopbackAddress() &&
                (remoteHost.getPort() == ProxyConfig.getInstance().getLocalPort())) {
            remoteEndpoint = new DefaultEndpoint();
            remoteEndpoint.setLocal(true);
            
            ret = false;
        } else {
            remoteEndpoint = new DefaultEndpoint(remoteHost);
            httpReq.addHeader(LoadBalancerProxyConstants.HTTP_PROXY_HEADER,
                    remoteHost.getAddress().toString());
        }
        
        if (_logger.isLoggable(Level.FINE)) {
            httpReq.dump();
        }        
        httpReq.setConvergedLoadBalancerEndpoint(remoteEndpoint);
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.test.loadbalancerlayer_end");
        }
        return ret;
    }
}
