/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * Portions Copyright Apache Software Foundation.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.http.util;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;

import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;


import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class is an extension of the grizzly request class.
 *
 * @rampsarathy
 */
public class HttpRequest extends Request {

    protected Endpoint clbEndpoint = null;
    private Logger _logger = ProxyConfig.getInstance().getLogger();
    protected boolean secure = false;
    protected SelectionKey selectionKey = null;

    public void setConvergedLoadBalancerEndpoint(Endpoint endpoint) {
        clbEndpoint = endpoint;
    }

    public Endpoint getConvergedLoadBalancerEndpoint() {
        return clbEndpoint;
    }

    public void addHeader(String name, String value) {
        HttpInputBuffer buffer = (HttpInputBuffer) getInputBuffer();
        buffer.addHeader(name, value);
    }

    public void addHeader(byte [] buff){
        HttpInputBuffer buffer = (HttpInputBuffer) getInputBuffer();
        buffer.addHeader(buff);
    }

    public void dump() {
        HttpInputBuffer buffer = (HttpInputBuffer) getInputBuffer();
        StringBuffer sbuf = new StringBuffer();

        for (int i = 0; i < buffer.lastValidPos(); i++) {
            sbuf.append((char) buffer.getBytes()[i]);
        }

        _logger.log(Level.FINE, sbuf.toString());
    }

    public int getHeaderLength() {
        HttpInputBuffer buffer = (HttpInputBuffer) getInputBuffer();

        return buffer.getHeaderLength();
    }

    @Override
    public void recycle() {
        super.recycle();
        clbEndpoint = null;
        secure = false;
        selectionKey = null;
    }

    public void setSelectionKey(SelectionKey key) {
              selectionKey = key;
    }
    
    public void setAddresses() {
        try {
            SocketChannel channel = (SocketChannel) selectionKey.channel();
            Socket socket = channel.socket();
            super.remoteAddr().setString(
                    socket.getInetAddress().getHostAddress());
            super.localAddr().setString(
                    socket.getLocalAddress().getHostAddress());
            super.setRemotePort(socket.getPort());
            super.setLocalPort(socket.getLocalPort());

        } catch (Exception e) {
            _logger.log(Level.SEVERE, "setAddresses ", e);
        }
    }

    public void dumpHeaders() {
        _logger.log(Level.FINE, "clb.proxy.http.request_uri", requestURI());

        try {
            MimeHeaders headers = getMimeHeaders();
            Enumeration names = getMimeHeaders().names();

            while (names.hasMoreElements()) {
                String headername = (String) names.nextElement();
                _logger.log(Level.FINE, "clb.proxy.http_header_name", headername);
                _logger.log(Level.FINE,
                        "clb.proxy.http_header_value", headers.getHeader(headername));
            }
            _logger.log(Level.FINE, "clb.proxy.http.request_remote_addr",
                    remoteAddr().toString());
            _logger.log(Level.FINE, "clb.proxy.http.request_remote_port",
                    getRemotePort());
            _logger.log(Level.FINE, "clb.proxy.http.request_local_addr",
                    localAddr().toString());
            _logger.log(Level.FINE, "clb.proxy.http.request_local_port",
                    getLocalPort());

        } finally {
        }
    }

    public void setSecure(boolean secured) {
        secure = secured;
    }

    public boolean isSecure() {
        return secure;
    }
        
      @Override
      public MessageBytes remoteAddr() {
          if (super.remoteAddr().isNull() || 
                  (super.remoteAddr().getLength() == 0)){
              setAddresses();
          }
          
	return super.remoteAddr();
    } 

    @Override
    public MessageBytes localAddr() {
	 if (super.localAddr().isNull() ||
                 (super.localAddr().getLength() == 0)){
             setAddresses();
          }
	return super.localAddr();
    }    
   
    @Override
    public int getRemotePort(){
         if (super.getRemotePort() <=0 ){
              setAddresses();
          }
	return super.getRemotePort();
    }   
    
    @Override
    public int getLocalPort(){
        if (super.getLocalPort() <=0 ){
              setAddresses();
          }
	return super.getLocalPort();
    }
}
