/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.outbound;


// Grizzly 1.0 APIs
import com.sun.enterprise.web.connector.grizzly.SelectorThread;

// Grillzy 1.x.x APIs
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;

import org.jvnet.glassfish.comms.clb.proxy.ProxyRequestHandler;
import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;

import java.io.IOException;

import java.net.SocketAddress;

import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Manages the outbound connections.
 * @author
 */
public class ConnectionManager {
    /**
     * Table for holding the proxy to backend instance mapprings.
     */
    private ConcurrentHashMap<Endpoint, ConnectorHandler> proxyTobackend = new ConcurrentHashMap<Endpoint, ConnectorHandler>();
    
    /**
     * Table for holding the client to proxy channel mappring.
     */
    private ConcurrentHashMap<SelectionKey, ProxyRequestHandler> clientToproxy = new ConcurrentHashMap<SelectionKey, ProxyRequestHandler>();
    
    /**
     * Cacheable pool of handlers.
     */
    protected ConnectorHandlerPool cacheableHandlerPool;
    
    /**
     * Grizzly 15 controller.
     */
    protected Controller controller;
    
    /**
     * Selector handler for this controller.
     */
    private SelectorHandler selectorHandler;
    
    /**
     * Logger
     */
    private Logger _logger = null;
    private SelectorThread selectorThread = null;
    
    /** Creates a new instance of ConnectionManager */
    public ConnectionManager() {
        _logger = ProxyConfig.getInstance().getLogger();
    }
    
    /**
     * Creates the handler pool and registers the controller.
     */
    public void createConnectionHandlerPool() {
        controller = new Controller();
        selectorHandler = new TCPSelectorHandler(true);
        controller.setSelectorHandler(selectorHandler);
        
        /**
         * Have to move this thread creation part to the
         * ConvergedProxy.
         */
        try {
            Thread t1 = new Thread(controller);
            t1.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void destroyConnectionHandlerPool() {
        // stop the controller
    }
    
    public ConnectorHandler getHandler(ProxyRequestHandler task) throws Exception{
        // add code for caching and returning
        return createHandler(task);
    }
    
    /**
     * Creater a TCP client connection handler.
     */
    private ConnectorHandler createHandler(ProxyRequestHandler task)
    throws Exception {
        Endpoint ep = task.getEndpoint();
        SocketAddress remote = ep.getSocketAddress();
        final ConnectorHandler connectorHandler =
                controller.acquireConnectorHandler(Controller.Protocol.TCP);
        
        CallbackHandler callbackHandler =
                new DefaultCallBackHandler(connectorHandler, task);
        try {
            connectorHandler.connect(remote, callbackHandler);
        } catch (Exception ex) {
            throw ex;
        }
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE,
                    "clb.proxy.connectionmanager.handler_created",
                    connectorHandler.getUnderlyingChannel() + "Local :" +
                    ((SocketChannel) connectorHandler.getUnderlyingChannel()).socket()
                    .getLocalAddress() + "Remote :" +
                    ((SocketChannel) connectorHandler.getUnderlyingChannel()).socket()
                    .getRemoteSocketAddress() + " for " + task.getEndpoint());
        }
        
        return connectorHandler;
    }
    
    public void putHandler(Endpoint ep, ConnectorHandler handler) {
        ConnectorHandler cached = proxyTobackend.putIfAbsent(ep, handler);
        if (cached != null) {
            try {
                handler.close(); //Race cond, remove if multiple are ok.
            } catch (Exception e) {
                ;
            }
        }
    }
    
    public void setSelectorThread(SelectorThread thread) {
        this.selectorThread = thread;
    }
    
    public void registerServerEndpoint(SelectionKey key, ProxyRequestHandler beEndpoint) {
        clientToproxy.put(key, beEndpoint);
    }
    
    public ProxyRequestHandler getServerEndpoint(SelectionKey key) {
        return clientToproxy.get(key);
    }
    
    public ProxyRequestHandler removeClientEndpoint(SelectionKey key) {
        return clientToproxy.remove(key);
    }
    
    public void releaseConnection(ConnectorHandler handler) {
        if (handler != null) {
            try {
                handler.close();
            } catch (IOException ex) {
                ex.printStackTrace();
            }
            controller.releaseConnectorHandler(handler);
        }
    }
    
    public void cancelClientKey(SelectionKey key) {
        if (key.isValid() && (selectorThread != null)) {
            selectorThread.cancelKey(key);
        }
    }
    
    public void registerClientKey(SelectionKey key) {
        if (key.isValid() && (selectorThread != null)) {
            selectorThread.registerKey(key);
        }
    }
}
