/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class ConvergedLbConfig extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);

	static public final String CONVERGED_LB_POLICY = "ConvergedLbPolicy";
	static public final String CONVERGED_LB_CLUSTER_REF = "ConvergedLbClusterRef";
	static public final String SERVER_REF = "ServerRef";
	static public final String ELEMENT_PROPERTY = "ElementProperty";

	public ConvergedLbConfig() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public ConvergedLbConfig(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(4);
		this.createProperty("converged-lb-policy", CONVERGED_LB_POLICY, 
			Common.TYPE_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			ConvergedLbPolicy.class);
		this.createAttribute(CONVERGED_LB_POLICY, "http", "Http", 
						AttrProp.CDATA,
						null, "round-robin");
		this.createAttribute(CONVERGED_LB_POLICY, "sip", "Sip", 
						AttrProp.CDATA,
						null, "from-tag,to-tag,call-id");
		this.createAttribute(CONVERGED_LB_POLICY, "dcr-file", "DcrFile", 
						AttrProp.CDATA | AttrProp.IMPLIED,
						null, null);
		this.createProperty("converged-lb-cluster-ref", CONVERGED_LB_CLUSTER_REF, Common.SEQUENCE_OR | 
			Common.TYPE_0_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			ConvergedLbClusterRef.class);
		this.createAttribute(CONVERGED_LB_CLUSTER_REF, "ref", "Ref", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(CONVERGED_LB_CLUSTER_REF, "self-loadbalance", "SelfLoadbalance", 
						AttrProp.CDATA,
						null, "true");
		this.createProperty("server-ref", SERVER_REF, Common.SEQUENCE_OR | 
			Common.TYPE_0_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			ServerRef.class);
		this.createAttribute(SERVER_REF, "ref", "Ref", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(SERVER_REF, "disable-timeout-in-minutes", "DisableTimeoutInMinutes", 
						AttrProp.CDATA,
						null, "30");
		this.createAttribute(SERVER_REF, "lb-enabled", "LbEnabled", 
						AttrProp.CDATA,
						null, "false");
		this.createAttribute(SERVER_REF, "enabled", "Enabled", 
						AttrProp.CDATA,
						null, "true");
		this.createProperty("property", ELEMENT_PROPERTY, 
			Common.TYPE_0_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			ElementProperty.class);
		this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	// This attribute is mandatory
	public void setConvergedLbPolicy(ConvergedLbPolicy value) {
		this.setValue(CONVERGED_LB_POLICY, value);
	}

	// Get Method
	public ConvergedLbPolicy getConvergedLbPolicy() {
		return (ConvergedLbPolicy)this.getValue(CONVERGED_LB_POLICY);
	}

	// Get Method
	public ConvergedLbClusterRef getConvergedLbClusterRef(int index) {
		return (ConvergedLbClusterRef)this.getValue(CONVERGED_LB_CLUSTER_REF, index);
	}

	// This attribute is an array, possibly empty
	public void setConvergedLbClusterRef(ConvergedLbClusterRef[] value) {
		this.setValue(CONVERGED_LB_CLUSTER_REF, value);
		if (value != null && value.length > 0) {
			// It's a mutually exclusive property.
			setServerRef(null);
		}
	}

	// Getter Method
	public ConvergedLbClusterRef[] getConvergedLbClusterRef() {
		return (ConvergedLbClusterRef[])this.getValues(CONVERGED_LB_CLUSTER_REF);
	}

	// Return the number of properties
	public int sizeConvergedLbClusterRef() {
		return this.size(CONVERGED_LB_CLUSTER_REF);
	}

	// Add a new element returning its index in the list
	public int addConvergedLbClusterRef(ConvergedLbClusterRef value)
			throws ConfigException{
		return addConvergedLbClusterRef(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addConvergedLbClusterRef(ConvergedLbClusterRef value, boolean overwrite)
			throws ConfigException{
		ConvergedLbClusterRef old = getConvergedLbClusterRefByRef(value.getRef());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(ConvergedLbConfig.class).getString("cannotAddDuplicate",  "ConvergedLbClusterRef"));
		}
		return this.addValue(CONVERGED_LB_CLUSTER_REF, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeConvergedLbClusterRef(ConvergedLbClusterRef value){
		return this.removeValue(CONVERGED_LB_CLUSTER_REF, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeConvergedLbClusterRef(ConvergedLbClusterRef value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(CONVERGED_LB_CLUSTER_REF, value, overwrite);
	}

	public ConvergedLbClusterRef getConvergedLbClusterRefByRef(String id) {
	 if (null != id) { id = id.trim(); }
	ConvergedLbClusterRef[] o = getConvergedLbClusterRef();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.REF)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	// Get Method
	public ServerRef getServerRef(int index) {
		return (ServerRef)this.getValue(SERVER_REF, index);
	}

	// This attribute is an array, possibly empty
	public void setServerRef(ServerRef[] value) {
		this.setValue(SERVER_REF, value);
		if (value != null && value.length > 0) {
			// It's a mutually exclusive property.
			setConvergedLbClusterRef(null);
		}
	}

	// Getter Method
	public ServerRef[] getServerRef() {
		return (ServerRef[])this.getValues(SERVER_REF);
	}

	// Return the number of properties
	public int sizeServerRef() {
		return this.size(SERVER_REF);
	}

	// Add a new element returning its index in the list
	public int addServerRef(ServerRef value)
			throws ConfigException{
		return addServerRef(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addServerRef(ServerRef value, boolean overwrite)
			throws ConfigException{
		ServerRef old = getServerRefByRef(value.getRef());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(ConvergedLbConfig.class).getString("cannotAddDuplicate",  "ServerRef"));
		}
		return this.addValue(SERVER_REF, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeServerRef(ServerRef value){
		return this.removeValue(SERVER_REF, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeServerRef(ServerRef value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(SERVER_REF, value, overwrite);
	}

	public ServerRef getServerRefByRef(String id) {
	 if (null != id) { id = id.trim(); }
	ServerRef[] o = getServerRef();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.REF)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	// Get Method
	public ElementProperty getElementProperty(int index) {
		return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
	}

	// This attribute is an array, possibly empty
	public void setElementProperty(ElementProperty[] value) {
		this.setValue(ELEMENT_PROPERTY, value);
	}

	// Getter Method
	public ElementProperty[] getElementProperty() {
		return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
	}

	// Return the number of properties
	public int sizeElementProperty() {
		return this.size(ELEMENT_PROPERTY);
	}

	// Add a new element returning its index in the list
	public int addElementProperty(ElementProperty value)
			throws ConfigException{
		return addElementProperty(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addElementProperty(ElementProperty value, boolean overwrite)
			throws ConfigException{
		ElementProperty old = getElementPropertyByName(value.getName());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(ConvergedLbConfig.class).getString("cannotAddDuplicate",  "ElementProperty"));
		}
		return this.addValue(ELEMENT_PROPERTY, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeElementProperty(ElementProperty value){
		return this.removeValue(ELEMENT_PROPERTY, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeElementProperty(ElementProperty value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
	}

	public ElementProperty getElementPropertyByName(String id) {
	 if (null != id) { id = id.trim(); }
	ElementProperty[] o = getElementProperty();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.NAME)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	/**
	* Getter for Name of the Element converged-lb-config
	* @return  the Name of the Element converged-lb-config
	*/
	public String getName() {
		return getAttributeValue(ServerTags.NAME);
	}
	/**
	* Modify  the Name of the Element converged-lb-config
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.NAME, v, overwrite);
	}
	/**
	* Modify  the Name of the Element converged-lb-config
	* @param v the new value
	*/
	public void setName(String v) {
		setAttributeValue(ServerTags.NAME, v);
	}
	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public ConvergedLbPolicy newConvergedLbPolicy() {
		return new ConvergedLbPolicy();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public ConvergedLbClusterRef newConvergedLbClusterRef() {
		return new ConvergedLbClusterRef();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public ServerRef newServerRef() {
		return new ServerRef();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public ElementProperty newElementProperty() {
		return new ElementProperty();
	}

	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "converged-lb-config" + (canHaveSiblings() ? "[@name='" + getAttributeValue("name") +"']" : "") ;
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
		str.append(indent);
		str.append("ConvergedLbPolicy");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getConvergedLbPolicy();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(CONVERGED_LB_POLICY, 0, str, indent);

		str.append(indent);
		str.append("ConvergedLbClusterRef["+this.sizeConvergedLbClusterRef()+"]");	// NOI18N
		for(int i=0; i<this.sizeConvergedLbClusterRef(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getConvergedLbClusterRef(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(CONVERGED_LB_CLUSTER_REF, i, str, indent);
		}

		str.append(indent);
		str.append("ServerRef["+this.sizeServerRef()+"]");	// NOI18N
		for(int i=0; i<this.sizeServerRef(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getServerRef(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(SERVER_REF, i, str, indent);
		}

		str.append(indent);
		str.append("ElementProperty["+this.sizeElementProperty()+"]");	// NOI18N
		for(int i=0; i<this.sizeElementProperty(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getElementProperty(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
		}

	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("ConvergedLbConfig\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

