/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class ConvergedLoadBalancer extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);

	static public final String PROXY = "Proxy";

	public ConvergedLoadBalancer() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public ConvergedLoadBalancer(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(1);
		this.createProperty("proxy", PROXY, 
			Common.TYPE_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			Proxy.class);
		this.createAttribute(PROXY, "request-pool-size", "RequestPoolSize", 
						AttrProp.CDATA,
						null, "50");
		this.createAttribute(PROXY, "send-retry-count", "SendRetryCount", 
						AttrProp.CDATA,
						null, "3");
		this.createAttribute(PROXY, "read-timeout-in-millis", "ReadTimeoutInMillis", 
						AttrProp.CDATA,
						null, "1500");
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	// This attribute is mandatory
	public void setProxy(Proxy value) {
		this.setValue(PROXY, value);
	}

	// Get Method
	public Proxy getProxy() {
		return (Proxy)this.getValue(PROXY);
	}

	/**
	* Getter for Name of the Element converged-load-balancer
	* @return  the Name of the Element converged-load-balancer
	*/
	public String getName() {
		return getAttributeValue(ServerTags.NAME);
	}
	/**
	* Modify  the Name of the Element converged-load-balancer
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.NAME, v, overwrite);
	}
	/**
	* Modify  the Name of the Element converged-load-balancer
	* @param v the new value
	*/
	public void setName(String v) {
		setAttributeValue(ServerTags.NAME, v);
	}
	/**
	* Getter for ConfigFile of the Element converged-load-balancer
	* @return  the ConfigFile of the Element converged-load-balancer
	*/
	public String getConfigFile() {
		return getAttributeValue(ServerTags.CONFIG_FILE);
	}
	/**
	* Modify  the ConfigFile of the Element converged-load-balancer
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setConfigFile(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.CONFIG_FILE, v, overwrite);
	}
	/**
	* Modify  the ConfigFile of the Element converged-load-balancer
	* @param v the new value
	*/
	public void setConfigFile(String v) {
		setAttributeValue(ServerTags.CONFIG_FILE, v);
	}
	/**
	* Getter for AutoCommit of the Element converged-load-balancer
	* @return  the AutoCommit of the Element converged-load-balancer
	*/
	public boolean isAutoCommit() {
		return toBoolean(getAttributeValue(ServerTags.AUTO_COMMIT));
	}
	/**
	* Modify  the AutoCommit of the Element converged-load-balancer
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setAutoCommit(boolean v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.AUTO_COMMIT, ""+(v==true), overwrite);
	}
	/**
	* Modify  the AutoCommit of the Element converged-load-balancer
	* @param v the new value
	*/
	public void setAutoCommit(boolean v) {
		setAttributeValue(ServerTags.AUTO_COMMIT, ""+(v==true));
	}
	/**
	* Get the default value of AutoCommit from dtd
	*/
	public static String getDefaultAutoCommit() {
		return "false".trim();
	}
	/**
	* Getter for ConvergedLbConfigName of the Element converged-load-balancer
	* @return  the ConvergedLbConfigName of the Element converged-load-balancer
	*/
	public String getConvergedLbConfigName() {
		return getAttributeValue(ServerTags.CONVERGED_LB_CONFIG_NAME);
	}
	/**
	* Modify  the ConvergedLbConfigName of the Element converged-load-balancer
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setConvergedLbConfigName(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.CONVERGED_LB_CONFIG_NAME, v, overwrite);
	}
	/**
	* Modify  the ConvergedLbConfigName of the Element converged-load-balancer
	* @param v the new value
	*/
	public void setConvergedLbConfigName(String v) {
		setAttributeValue(ServerTags.CONVERGED_LB_CONFIG_NAME, v);
	}
	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public Proxy newProxy() {
		return new Proxy();
	}

	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "converged-load-balancer";
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
		if(attr.equals(ServerTags.AUTO_COMMIT)) return "false".trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
		str.append(indent);
		str.append("Proxy");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getProxy();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(PROXY, 0, str, indent);

	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("ConvergedLoadBalancer\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

