/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.admin;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder =  {
    "instance", "webModule", "property"}
)
@XmlRootElement(name = "cluster")
public class Cluster {
    @XmlAttribute(required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String name;
    @XmlAttribute(name = "self-loadbalance")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String selfLoadbalance;
    protected List<Instance> instance;
    @XmlElement(name = "web-module")
    protected List<WebModule> webModule;
    protected List<Property> property;

    /**
     * Gets the value of the name property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the selfLoadbalance property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getSelfLoadbalance() {
        if (selfLoadbalance == null) {
            return "true";
        } else {
            return selfLoadbalance;
        }
    }

    /**
     * Sets the value of the selfLoadbalance property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setSelfLoadbalance(String value) {
        this.selfLoadbalance = value;
    }

    /**
     * Gets the value of the instance property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the instance property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInstance().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Instance }
     *
     *
     */
    public List<Instance> getInstance() {
        if (instance == null) {
            instance = new ArrayList<Instance>();
        }

        return this.instance;
    }

    /**
     * Gets the value of the webModule property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the webModule property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getWebModule().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WebModule }
     *
     *
     */
    public List<WebModule> getWebModule() {
        if (webModule == null) {
            webModule = new ArrayList<WebModule>();
        }

        return this.webModule;
    }

    /**
     * Gets the value of the property property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the property property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProperty().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Property }
     *
     *
     */
    public List<Property> getProperty() {
        if (property == null) {
            property = new ArrayList<Property>();
        }

        return this.property;
    }

    //Manually added methods begin here - (not jaxb generated)
    /**
     * Method to add a new Server Instance to the cluster
     * @param instance - the new Server Instance that needs to be added to the cluster
     */
    public void addInstance(Instance instance) {
        getInstance().add(instance);
    }

    /**
     * Method to find an Instance based on its name
     * @param name - The name of the Instance to find
     * @return the reference to the Instance if the name matches one in the Instance list else return null
     */
    public Instance findInstance(String name) {
        if (name == null) {
            return null;
        }

        for (int i = 0; i < getInstance().size(); i++) {
            Instance in = getInstance().get(i);

            if (name.equals(in.getName())) {
                return in;
            }
        }

        return null;
    }

    /**
    * Method to add a new Web Module to the cluster
    * @param module - the new Web Module that needs to be added to the cluster
    */
    public void addWebmodule(WebModule module) {
        this.getWebModule().add(module);
    }

    /**
     * Method to find a Web Module based on its context-root
     * @param contextRoot - The context root of the Web Module to find
     * @return the reference to the Web Module if the name matches one in the Web Module list else return null
     */
    public WebModule findWebModule(String contextRoot) {
        if (contextRoot == null) {
            return null;
        }

        for (int i = 0; i < getWebModule().size(); i++) {
            WebModule wm = getWebModule().get(i);

            if (contextRoot.equals(wm.getContextRoot())) {
                return wm;
            }
        }

        return null;
    }
}
