/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.servlet.sip.SipServletRequest;


public class ContainsOperand extends Operand {
    /**
          * serialViersion
          */
    private static final long serialVersionUID = 1L;

    /**
    * Specifies a variable
    */
    private String variable;

    /**
     * Specifies a literal string value that is used to specify rules
     */
    private String value;

    /**
     * Specifies whether the "contains" test is case sensitive or not
     */
    private boolean ignoreCase = false;

    /**
     * Evaluate the condition
     *
     * @param object
     *        The object to evaluate
     * @return True if the value of the variable contains the specified literal
     *         value
     */
    public boolean evaluate(Object object) {
        String attribute = getAttributeValue(variable,
                (SipServletRequest) object);

        if (attribute == null) // Incase of getAttributeValue return null.
         {
            return false;
        }

        String compareAttribute = attribute;
        String compareValue = value;

        if (ignoreCase) {
            compareAttribute = attribute.toLowerCase();
            compareValue = value.toLowerCase();
        }

        return (compareAttribute.indexOf(compareValue) != -1);
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws Exception {
        throw new UnsupportedOperationException("Method needs implementation");
    }

    /**
     * @return
     */
    public String getVariable() {
        return variable;
    }

    /**
     * @param variable
     */
    public void setVariable(String variable) {
        this.variable = variable;
    }

    /**
     * Called by the digester with string value of true or false.
     * @param ignoreCase
     */
    public void setIgnoreCase(String ignoreCase) {
        this.ignoreCase = Boolean.parseBoolean(ignoreCase);
    }

    /**
     * @return
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Returns the value of ignore case.
     * @return boolean if ignore case is false or true.
     */
    public boolean isIgnoreCase() {
        return ignoreCase;
    }
}
