/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import java.util.Collection;
import java.util.HashMap;


public abstract class Enum {
    private static HashMap enumClasses = new HashMap(10);
    private String name;

    protected Enum(String name) {
        if ((name == null) || (name.length() == 0)) {
            throw new IllegalArgumentException("Invalid enum name: " + name);
        }

        Entry entry = getEntry(getClass());

        if (entry == null) {
            entry = new Entry();
            enumClasses.put(getClass(), entry);
        }

        if (entry.enumValues.containsKey(name)) {
            throw new IllegalArgumentException("Enum already exists for " +
                getClass().getName() + " and name " + name);
        }

        this.name = name;
        entry.enumValues.put(name, this);
    }

    public String getName() {
        return name;
    }

    protected static String[] getNames(Class class_) {
        Entry entry = (Entry) enumClasses.get(class_);
        assertEntryNotNull(entry, class_);

        return (String[]) entry.enumValues.keySet()
                                          .toArray(new String[entry.enumValues.size()]);
    }

    protected static boolean contains(Class class_, String name) {
        Entry entry = getEntry(class_);
        assertEntryNotNull(entry, class_);

        return entry.enumValues.containsKey(name);
    }

    protected static Entry getEntry(Class class_) {
        return (Entry) enumClasses.get(class_);
    }

    protected static String toString(Class class_) {
        String[] names = getNames(class_);
        StringBuffer buffer = new StringBuffer("[");

        for (int i = 0; i != names.length; ++i) {
            buffer.append(names[i]);

            if (i != (names.length - 1)) {
                buffer.append(", ");
            }
        }

        buffer.append("]");

        return buffer.toString();
    }

    protected static Collection getEnumList(Class class_) {
        Entry entry = getEntry(class_);
        assertEntryNotNull(entry, class_);

        return entry.enumValues.values();
    }

    protected static Collection getEnumNameList(Class class_) {
        Entry entry = getEntry(class_);
        assertEntryNotNull(entry, class_);

        return entry.enumValues.keySet();
    }

    private static void assertEntryNotNull(Entry entry, Class class_) {
        if (entry == null) {
            throw new IllegalArgumentException("No Enum exists for type " +
                class_.getName());
        }
    }

    private static class Entry {
        HashMap enumValues = new HashMap(10);
    }
}
