/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.servlet.sip.SipServletRequest;


/**
 * EqualOperand. The EqualOperand operand verify the equality for a particular
 * attribute of the request
 */
public class EqualOperand extends Operand {
    private static final long serialVersionUID = 3258133544273786673L;

    /**
     * Specifies a variable
     */
    private String variable;

    /**
     * Specifies a literal string value that is used to specify rules
     */
    private String value;

    /**
     * Specifies whether the "contains" test is case sensitive or not
     */
    private boolean ignoreCase;

    /**
     *
     *
     *
     */
    public EqualOperand() {
    }

    /**
     * @param var
     * @param value
     * @param ignoreCase
     * @throws SipParserException
     */
    public EqualOperand(String var, String value, boolean ignoreCase)
        throws Exception {
        this.variable = var;
        this.value = value;
        this.ignoreCase = ignoreCase;

        if ((var == null) || (value == null)) {
            throw new Exception(
                "equals() value/variable must be non-null");
        }

        if (!isVarValueSupported(var, value)) {
            throw new Exception("equals() variable=" + var +
                "  value=" + value + ", not supported");
        }
    }

    /**
     * Evaluate the condition
     *
     * @param object
     *        The object to evaluate
     * @return True if the value of the variable equals the specified literal
     *         value
     */
    public boolean evaluate(Object object) {
        SipServletRequest request = (SipServletRequest) object;
        String a = request.getMethod();

        return ignoreCase
        ? this.value.equalsIgnoreCase(getAttributeValue(variable, request))
        : this.value.equals(getAttributeValue(variable, request));
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws Exception {
        Hashtable<String, ArrayList<String>> equalTable = new Hashtable<String, ArrayList<String>>();

        if (isMethodOrSessionCase(this.variable)) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.value);
            equalTable.put(this.variable, values);
        }

        return equalTable;
    }

    /**
     * @return
     */
    public String getVariable() {
        return variable;
    }

    /**
     * @param variable
     */
    public void setVariable(String variable) {
        this.variable = variable;
    }

    /**
     * @return
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     */
    public void setValue(String value) {
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("balba");
        }

        this.value = value;
    }

    /**
     * @return
     */
    public String toString() {
        return "" + this.variable.toString() + " == \"" + value.toString() +
        "\"";
    }

    /**
     *
     * @param ignoreCase
     */
    public void setIgnoreCase(String ignoreCase) {
        this.ignoreCase = Boolean.parseBoolean(ignoreCase);
    }

    /**
     *
     * @return The session case for equal operand
     */
    public boolean isIgnoreCase() {
        return ignoreCase;
    }
}
