/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import java.io.Serializable;

import java.util.*;

import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.SecurityRoleReference;

public class Servlet implements Serializable {
    private static final long serialVersionUID = 3258412845946254135L;
    private String smallIcon;
    private String largeIcon;
    private String servletName;
    private String displayName;
    private String description;
    private String servletClass;
    private Set initializationParameters;
    private int loadOnStartup;
    private RunAsIdentityDescriptor runAs;
    private String runAsRoleName;
    private Set<SecurityRoleReference> securityRoleReferences;
    private PrincipalNameDescriptor principalNameDescriptor = null;
    private String packageName;
    private String applicationName;

    /**
     * Default constructor.
     */
    public Servlet() {
    }

    /**
     * @param parameter
     */
   /* public void addInitParameter(Parameter parameter) {
        if (initParameters == null) {
            initParameters = new HashMap<String, Parameter>();
        }

        if (initParameters.get(parameter.getName()) != null) {
            throw new RuntimeException("Each parameter name must be unique " +
                "in the initialization parameter");
        }

        initParameters.put(parameter.getName(), parameter);
    } */

    private Set getInitializationParameterSet() {
	if (this.initializationParameters == null) {
	    this.initializationParameters = new OrderedSet();
	}
	return this.initializationParameters = 
                new OrderedSet(this.initializationParameters);
    }
    
	/**
	* Return the Set of servlet initialization parameters.
	*/
   /* public Enumeration getInitializationParameters() {
	return (new Vector(this.getInitializationParameterSet())).elements();
    }*/
    
    public Enumeration getInitParameterNames() {
        
        Vector ipNames = new Vector<String>();
        for(Iterator ips = getInitializationParameterSet().iterator(); 
              ips.hasNext();) {
             String ipName =
                     ((EnvironmentProperty)ips.next()).getName();
             ipNames.add(ipName);
        }
        return ipNames.elements();
   }
    
	/**
	* Return a matching initialization parameter by its name if there is one.
	*/
    public InitializationParameter getInitializationParameterByName(String name) {
	for (Iterator itr = this.getInitializationParameterSet().iterator(); itr.hasNext();) {
	    InitializationParameter next = (InitializationParameter) itr.next();
	    if (next.getName().equals(name)) {
		return next;
	    }
	}
	return null;
    }
    
    /**
     * Adds a servlet initialization parameter to this component.
     */
    public void addInitializationParameter(InitializationParameter
            initializationParameter) {
        for (Enumeration e =getInitParameterNames(); e.hasMoreElements();) {
            if(((String)e.nextElement())
                    .equals(initializationParameter.getName())) {
                throw new RuntimeException("Each parameter name must be unique " +
                    "in the initialization parameter");             
             }
        }
        this.getInitializationParameterSet().add(initializationParameter);
	
    }
    
    /**
    * Removes the given servlet initialization parameter from this component.
    */
    public void removeInitializationParameter(InitializationParameter initializationParameter) {
	this.getInitializationParameterSet().remove(initializationParameter);
	
    }
    
    /** Security Role references */
    Set getSecurityRoleReferenceSet() {
	if (this.securityRoleReferences == null) {
	    this.securityRoleReferences = new OrderedSet();
	}
	return this.securityRoleReferences = new OrderedSet(this.securityRoleReferences);
    }
    
    /**
    * Return the Set of security role references that I have.
    */
    public Enumeration getSecurityRoleReferences() {
	return (new Vector(this.getSecurityRoleReferenceSet())).elements();
    }
    
    /** 
    * Return a matching role reference by name or null if there is none matching.
    */
    public SecurityRoleReference getSecurityRoleReferenceByName(
                String roleReferenceName) {
	for (Enumeration e = 
                this.getSecurityRoleReferences(); e.hasMoreElements();) {
	    SecurityRoleReference nextRR = 
                    (SecurityRoleReference) e.nextElement();
	    if (nextRR.getRolename().equals( roleReferenceName )) {
		return nextRR; 
	    }
	}
	return null;   
    }
    
    /**
    * Adds a security role reference to this web component.
    */
    public void addSecurityRoleReference(SecurityRoleReference
            securityRoleReference) {
	this.getSecurityRoleReferenceSet().add(securityRoleReference);
	
    }
    
    /** 
    * Removes the given security role reference from this web component.
    */
    public void removeSecurityRoleReference(SecurityRoleReference
            securityRoleReference) {
	this.getSecurityRoleReferenceSet().remove(securityRoleReference);
	
    }

    /**
     * @return
     */
   /* public Map getInitParameters() {
        return initParameters;
    } */

    /**
     * @param initParameterName
     * @return
     */
    /* public Parameter getInitParameter(String initParameterName) {
        return (Parameter) initParameters.get(initParameterName);
    }*/

    /**
     * @return
     */
    public String getSmallIcon() {
        return smallIcon;
    }

    /**
     * @param smallIcon
     */
    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    /**
     * @return
     */
    public String getLargeIcon() {
        return largeIcon;
    }

    /**
     * @param largeIcon
     */
    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    /**
     * @return
     */
    public String getServletName() {
        return servletName;
    }

    /**
     * @param servletName
     */
    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    /**
     * @return
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */
    public String getServletClass() {
        return servletClass;
    }

    /**
     * @param servletClass
     */
    public void setServletClass(String servletClass) {
        this.servletClass = servletClass;
    }

    /**
     * @return
     */
    public int getLoadOnStartup() {
        return loadOnStartup;
    }

    /**
     * @param loadOnStartup
     */
    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    /**
     * This method will be called by the digester.
     * @param loadOnStartup
     */
    public void setLoadOnStartup(String loadOnStartup) {
        // This method will fix the problem when the app. developer
        // write <load-on-startup/> with on tag. The digester will
        // this method with an empty String.
        if (!loadOnStartup.equals("")) {
            this.loadOnStartup = Integer.valueOf(loadOnStartup);
        }
    }

     /**
      * Gets the run-as of the referee EJB.
      * @return the value of run-as.
      */
     public void setRunAsIdentity(RunAsIdentityDescriptor runAs) {
         if (this.runAs == null) {
             this.runAs = runAs;
         }
     }
     
    /**
      * Sets the run-as of the referee EJB.
      * @param the value of run-as
      */ 
     public RunAsIdentityDescriptor getRunAsIdentity() {
         return this.runAs;
     }    

     public boolean getUsesCallerIdentity() {
	return (this.runAs==null);
     }

     public void setUsesCallerIdentity(boolean isCallerID) {
	if (isCallerID) { 
	    this.runAs = null;
	} else {
	    this.runAs = new RunAsIdentityDescriptor("");
        }
     }
     
    /**
     * @return
     */
    /* public String getRunAsDescription() {
        return runAsDescription;
    } */

    /**
     * @param runAsDescription
     */
    /* public void setRunAsDescription(String runAsDescription) {
        this.runAsDescription = runAsDescription;
    } */

    /**
     * @return
     */
    public String getRunAsRoleName() {
        return runAsRoleName;
    } 

    /**
     * @param runAsRoleName
     */
    /* public void setRunAsRoleName(String runAsRoleName) {
        this.runAsRoleName = runAsRoleName;
    } */

   /**
    * Setter method for Principal Name in the sun-sip.xml
    * @param PrincipalNamedescriptor
    */ 
    public void addPrincipalName(PrincipalNameDescriptor desc) {
        this.principalNameDescriptor = desc;
    }

   /**
    * Getter method for Principal Name in the sun-sip.xml
    * @return PrincipalNamedescriptor
    */ 
    public PrincipalNameDescriptor getPrincipalName() {
        return this.principalNameDescriptor;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;

    }

    public String getPackageName() {
        return packageName;
    }

    public void setApplicationName(String annotatedAppliationName) {
        this.applicationName = annotatedAppliationName;
        
    }

    public String getApplicationName() {
        return applicationName;
    }

}
