/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.deployment.web.SecurityRole;
import java.io.Serializable;
import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.NotificationEvent;

import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;

import com.sun.enterprise.deployment.util.XModuleType;

import org.jvnet.glassfish.comms.deployment.backend.SipApplicationBase;
import org.jvnet.glassfish.comms.deployment.backend.ProxyConfig;
import org.jvnet.glassfish.comms.deployment.backend.SecurityConstraint;
import org.jvnet.glassfish.comms.deployment.runtime.sip.SunSipApp;



public class SipApplication extends BundleDescriptor 
    implements  WritableJndiNameEnvironment,
                ResourceReferenceContainer,
                ResourceEnvReferenceContainer,
                EjbReferenceContainer,
                MessageDestinationReferenceContainer,
                ServiceReferenceContainer,
                NotificationListener,
                ArchiveDescriptor{
    
    private static final long serialVersionUID = 3258415023411114551L;
    public static final int UNKNOWN_TIMEOUT_VALUE = Integer.MIN_VALUE;
    
    public static final String MODULE_TYPE = 
            "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer";
    public static final String SPEC_VERSION = "1.1";
    
    private String smallIcon;
    private String largeIcon;
    private String displayName;
    private String description;
    private boolean distributable;
    private Set contextParameters;
    private Collection<String> listeners;
    private Map<String, Servlet> servlets;
    private Map<String, ServletMapping> servletMappings;
    private long proxyConfigSequentialSearchTimeout;
    private int sessionConfigTimeout = UNKNOWN_TIMEOUT_VALUE;
    private Set<JmsDestinationReferenceDescriptor> jmsDestReferences
            = new HashSet<JmsDestinationReferenceDescriptor>();
    private Set<ResourceReference> resourceReferences
            = new HashSet<ResourceReference>();
    private Set<SecurityConstraint> securityConstraints
            = new HashSet<SecurityConstraint>();;
    private LoginConfiguration loginConfiguration;
    private String loginConfigAuthMethod;
    private String loginConfigRealmName;
    //private Map<String, SecurityRole> securityRoles;
    private Set<EnvironmentProperty> environmentEntries
            = new HashSet<EnvironmentProperty>();
    private Set<EjbReference> ejbReferences
            = new HashSet<EjbReference>();
    //private Set<EjbLocalReference> ejbLocalReferences;
    private String moduleName;
    private int version;
    private int sessionTimeout;
    private String defaultServlet;
    private String appName;

    Method sipApplicationKeyMethod;
    private String mainServletName;
    private String packageName = null;
    
    private LinkedHashMap<String, Servlet> annotatedServlets = new LinkedHashMap<String, Servlet>();
    
    private SipBundleDescriptor referringDescriptor;
    private SunSipApp sunSipApp = null;

    private Set<MessageDestinationReferenceDescriptor>
        messageDestRefDescriptorSet =
            new HashSet<MessageDestinationReferenceDescriptor>();

    private Set<EntityManagerReferenceDescriptor> entityMgrRefDescSet = 
            new HashSet<EntityManagerReferenceDescriptor>();

    private Set<ServiceReferenceDescriptor> serviceRefDescSet =
            new HashSet<ServiceReferenceDescriptor>();

    private Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryDescriptorSet =
            new HashSet<EntityManagerFactoryReferenceDescriptor>();
    
    /**
     * This class represents the sip.xml ( or the sip part of the SipBundleDescriptor
     * A SipApplication is a member variable of a SipBundleDescriptor and in 
     * turn has SunSipApp as a member variable.
     *
     *
     */
    public SipApplication() {
    }

    /**
     * @param servlet
     */
    public void addServlet(Servlet servlet) {
        if (servlets == null) {
            servlets = new LinkedHashMap<String, Servlet>();
        }

        if (servlets.get(servlet.getServletName()) != null) {
            throw new RuntimeException("Cannot have more than one servlet " +
                "with the same name in the sip deployment descriptor");
        }

        servlets.put(servlet.getServletName(), servlet);

        //Default servlet is the first one
        if ((defaultServlet == null) && (servlet != null)) {
            defaultServlet = servlet.getServletName();
        }
    }

    /**
     * @param servletMapping
     */
    public void addServletMapping(ServletMapping servletMapping) {
        if (servletMappings == null) {
            servletMappings = new HashMap<String, ServletMapping>();
        }

        /* This use to be a validation for 
        if (servlets.get(servletMapping.getServletName()) == null) {
            throw new RuntimeException("Cannot have a servlet mapping which " +
                "servlet name doesn't match a servlet defined in the " +
                "sip deployment descriptor");
        }
        */

        if (servletMappings.get(servletMapping.getServletName()) != null) {
            throw new RuntimeException("Cannot have more than one servlet " +
                "mapping per servlet name in the sip deployment descriptor");
        }

        servletMappings.put(servletMapping.getServletName(), servletMapping);
    }

    /**
     * @param listener
     */
    public void addListener(String listener) {
        if (listeners == null) {
            listeners = new ArrayList<String>();
        }

        listeners.add(listener);
    }
    
    /**
    * Returns the Set of my COntext Parameters.
    */
    public Set getContextParametersSet() {
	if (this.contextParameters == null) {
	    this.contextParameters = new OrderedSet();
	}
	return this.contextParameters = new OrderedSet(this.contextParameters);
    }
    
    /** Returns my COntext Parameters in an enumeration.
    */
    public Enumeration getContextParameters() {
	return (new Vector(this.getContextParametersSet())).elements();
    }
    
    /** Adds a new context parameter to my list.
    */
    public void addContextParameter(ContextParameter contextParameter) {
        for (Enumeration e = getContextParameters() ; e.hasMoreElements() ;) {
            if((contextParameter.getName()).equals(
                    ((ContextParameter)e.nextElement()).getName())) {
                throw new RuntimeException("Each parameter name must be unique " +
                    "in the context parameter");                
            }
        }
	this.getContextParametersSet().add(contextParameter);
	this.changed();
    }
    
    /** Adds a new context parameter to my list.
    */
    public void addContextParameter(EnvironmentProperty contextParameter) {
        addContextParameter((ContextParameter) contextParameter);
    }    
    
    /**
     * Removes the given context parameter from my list.
     */
    public void removeContextParameter(ContextParameter contextParameter) {
	this.getContextParametersSet().remove(contextParameter);
	this.changed();
    }    

    /** Return an enumeration of references to resources that I have.*/
    public Enumeration getResourceReferences() {
	return (new Vector(this.getResourceReferenceDescriptors())).elements();
    }
    
    /** adds a new reference to a resource.*/
    public void addResourceReference(ResourceReference resourceReference) {
	this.getResourceReferenceDescriptors().add(resourceReference);
	this.changed();
    }
    
    /** adds a new reference to a resource.*/
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
	this.addResourceReference((ResourceReference) resourceReference);
    }
    
   /**
    * Returns my Set of references to resources.
    */
    public Set getResourceReferenceDescriptors() {
	if (this.resourceReferences == null) {
	    this.resourceReferences = new OrderedSet();
	}
	return this.resourceReferences = new OrderedSet(this.resourceReferences);
    }
    
    /** removes a reference to a resource.*/
    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
	this.getResourceReferenceDescriptors().remove(resourceReference);
	this.changed();
    }
    
/**
	* Return the set of JMS destination references this ejb declares.
	*/
    public Set getJmsDestinationReferenceDescriptors() {
	if (this.jmsDestReferences == null) {
	    this.jmsDestReferences = new OrderedSet();
	}
	return this.jmsDestReferences = new OrderedSet(this.jmsDestReferences);
    }

    public void addJmsDestinationReferenceDescriptor(
            JmsDestinationReferenceDescriptor jmsDestReference) {
	this.getJmsDestinationReferenceDescriptors().add(jmsDestReference);
	this.changed();
    }
    
    public void removeJmsDestinationReferenceDescriptor(
            JmsDestinationReferenceDescriptor jmsDestReference) {
	this.getJmsDestinationReferenceDescriptors().remove(jmsDestReference);
	this.changed();
    }

    /**
    * Return a JMS destination reference by the same name or throw an IllegalArgumentException.
    */
    public JmsDestinationReferenceDescriptor getJmsDestinationReferenceByName(String name) {
	for (Iterator itr = this.getJmsDestinationReferenceDescriptors().iterator(); itr.hasNext();) {
	    JmsDestinationReferenceDescriptor jdr = (JmsDestinationReferenceDescriptor) itr.next();
	    if (jdr.getName().equals(name)) {
		return jdr;   
	    }
	}
	return null;
    }    
    
    /**
     * @param constraint
     */
    public void addSecurityConstraint(SecurityConstraint constraint) {
        if (securityConstraints == null) {
            securityConstraints = new HashSet<SecurityConstraint>();
        }
        securityConstraints.add(constraint);
    } 
    
    private Set getSecurityConstraintsSet() {
	if (this.securityConstraints == null) {
	    this.securityConstraints = new HashSet();
	}
	return this.securityConstraints;
    }
    
    /** My list of security constraints.*/
    public Enumeration getSecurityConstraints() {
	return (new Vector(this.getSecurityConstraintsSet())).elements();
    }

   
     /** Remove the given security constraint.*/
    public void removeSecurityConstraint(SecurityConstraint securityConstraint) {
	this.getSecurityConstraintsSet().remove(securityConstraint);
	this.changed();
    }    

    /**
     * @param environmentEntry
     */
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        if (environmentEntries == null) {
            environmentEntries = new OrderedSet();
        }
        environmentEntries.add(environmentProperty);
    }

    /**
     * @param ejbReference
     */
    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        if (ejbReferences == null) {
            ejbReferences = new OrderedSet();
        }
        ejbReference.setReferringBundleDescriptor(this);
        ejbReferences.add(ejbReference);
    }
    
   /** Adds a new reference to an ejb.*/

    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReferenceDescriptor) {
        ejbReferenceDescriptor.setReferringBundleDescriptor(this);
	this.addEjbReferenceDescriptor((EjbReference) ejbReferenceDescriptor);

    }

	/** Returns an Enumeration of my SecurityRole objects. */
    public Enumeration getSecurityRoles() {
	Vector securityRoles = new Vector();
	for (Iterator itr = super.getRoles().iterator(); itr.hasNext();) {
	    Role r = (Role) itr.next();
	    SecurityRoleDescriptor srd = new SecurityRoleDescriptor(r);
	    securityRoles.add(srd);
	}
	return securityRoles.elements();
    }
    
    /** Add a new abstrct role to me. */
    public void addSecurityRole(SecurityRole securityRole) {
	Role r = new Role(securityRole.getName());
	r.setDescription(securityRole.getDescription());
	super.addRole(r);
    }
    
    /** Add a new abstrct role to me. */
    public void addSecurityRole(SecurityRoleDescriptor securityRole) {    
        addSecurityRole((SecurityRole) securityRole);
    }
    
    /**
     * @return
     */
    public Map<String, Servlet> getServlets() {
        return (servlets != null) ? servlets : Collections.EMPTY_MAP;
    }

    /**
     * @param servletName
     * @return
     */
    public Servlet getServlet(String servletName) {
        return (Servlet) getServlets().get(servletName);
    }


    public Iterator<String> getServletNames(){
        return  getServlets().keySet().iterator();
    }

    public String getRunAsRoleName(String servletName){
        Servlet svt = (Servlet) getServlets().get(servletName);
        if(svt != null){
            if(svt.getRunAsIdentity() != null){
                return svt.getRunAsIdentity().getRoleName();            
            }
        }
        return null;
    }


    /**
     * First servlet that is added.
     * @return servlet name
     */
    public String getDefaultServlet() {
        return defaultServlet;
    }

    /**
     * @return
     */
    public Map<String, ServletMapping> getServletMappings() {
        return (servletMappings != null) ? servletMappings : Collections.EMPTY_MAP;
    }

    /**
     * @param servletName
     * @return
     */
    public ServletMapping getServletMappings(String servletName) {
        return (ServletMapping) servletMappings.get(servletName);
    }
    
    /**
     * Return the value in seconds of when requests should time out.
     */
    public int getSessionTimeout() {
	return this.sessionTimeout;
    }
    
	/** Sets thew value in seconds after sessions should timeout.
	*/
    public void setSessionTimeout(int sessionTimeout) {
	this.sessionTimeout = sessionTimeout;
	this.changed();
    }    

    /** Return the information about how I should log in.*/
    public LoginConfiguration getLoginConfiguration() {
	return this.loginConfiguration;
    }
    
    /** Specifies the information about how I should log in.*/
    public void setLoginConfiguration(LoginConfiguration loginConfiguration) {
	this.loginConfiguration = loginConfiguration;
	this.changed();
    }    

    /**
     * @return
     */
    public Collection<String> getListeners() {
        return (listeners != null) ? listeners : Collections.EMPTY_LIST;
    }

    /**
     * @return
     */
    public String getSmallIcon() {
        return smallIcon;
    }

    /**
     * @param smallIcon
     */
    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    /**
     * @return
     */
    public String getLargeIcon() {
        return largeIcon;
    }

    /**
     * @param largeIcon
     */
    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    /**
     * @return String the display name
     */
    public String getDisplayName() {
        return getLocalizedDisplayName(null);
    }

    public void setLocalizedDisplayName(String lang, String displayName) {
        super.setLocalizedDisplayName(lang, displayName);
    }
    /**
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * @return
     */
    public String getDescription() {
        return getLocalizedDescription(null);
    }
    
    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * @return
     */
    public boolean isDistributable() {
        return distributable;
    }

    /**
     *
     *
     *
     */
    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    /**
     * @return
     */
    public long getProxyConfigSequentialSearchTimeout() {
        return proxyConfigSequentialSearchTimeout;
    }

    /**
     * @param proxyConfigSequentialSearchTimeout
     */
    public void setProxyConfigSequentialSearchTimeout(
        String proxyConfigSequentialSearchTimeout) {
        this.proxyConfigSequentialSearchTimeout = Long.valueOf(proxyConfigSequentialSearchTimeout);
    }

    public void setProxyConfigSequentialSearchTimeout(
            int proxyConfigSequentialSearchTimeout) {
            this.proxyConfigSequentialSearchTimeout = proxyConfigSequentialSearchTimeout;
    }
    
    /**
     * @return
     */
    public int getSessionConfigTimeout() {
        return sessionConfigTimeout;
    }

    /**
     * @param sessionConfigTimeout
     */
    public void setSessionConfigTimeout(String sessionConfigTimeout) {
        if (!sessionConfigTimeout.equals("")) {
            this.sessionConfigTimeout = Integer.valueOf(sessionConfigTimeout);
        }
    }
    
    public void setSessionConfigTimeout(int sessionConfigTimeout) {
    	this.sessionConfigTimeout = sessionConfigTimeout;
    }

    /**
     * @return
     */
    public String getModuleName() {
        return moduleName;
    }

    /**
     * @param moduleName
     */
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    /**
     * @return
     */
    public int getVersion() {
        return version;
    }

    /**
     * @param version
     */
    public void setVersion(int version) {
        this.version = version;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setSipApplicationKey(Method sipApplicationKeyMethod) {
	this.sipApplicationKeyMethod = sipApplicationKeyMethod;
    }
	
    public Method getSipApplicationKey() {
	return this.sipApplicationKeyMethod;
    }

    public void setMainservletName(String mainServlet) {
	this.mainServletName = mainServlet;
    }
	
    public String getMainservletName() {
	return this.mainServletName;
    }

    public Set getServiceReferenceDescriptors() {
        return serviceRefDescSet;
    }

    public javax.enterprise.deploy.shared.ModuleType getModuleType() {
        return XModuleType.getModuleType(MODULE_TYPE);
    }

    public String getDefaultSpecVersion() {
        return SPEC_VERSION;
    }

    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
    }

    public void removeEjbReferenceDescriptor(EjbReference ejbReference) {
    }

    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestinationReferenceDescriptor) {
    }

    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestinationReferenceDescriptor) {
    }

    public void addPostConstructDescriptor(LifecycleCallbackDescriptor lifecycleCallbackDescriptor) {
    }

    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor lifecycleCallbackDescriptor) {
    }

    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceReferenceDescriptor) {
    }

    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceReferenceDescriptor) {
    }

    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor entityManagerFactoryReferenceDescriptor) {
    }

    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor entityManagerReferenceDescriptor) {
    }

    public Set getEnvironmentProperties() {
        return this.environmentEntries;
    }

    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
	for (Iterator itr = this.environmentEntries.iterator(); 
             itr.hasNext();) {
	    EnvironmentProperty ev = (EnvironmentProperty) itr.next();
	    if (ev.getName().equals(name)) {
		return ev;   
	    }
        }
        return null;
    }

    public Set getEjbReferenceDescriptors() {
        return this.ejbReferences;
    }

    public ServiceReferenceDescriptor getServiceReferenceByName(String string) {
        return null;        
    }

    public Set getMessageDestinationReferenceDescriptors() {
        return messageDestRefDescriptorSet;        
    }

    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String string) {
        return null;        
    }

    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        return null;        
    }

    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String string) {
        return null;        
    }

    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        return null;        
    }

    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String string) {
        return null;        
    }

    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
       return entityManagerFactoryDescriptorSet;
    }

    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String string) {
        return null;        
    }

    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        return entityMgrRefDescSet;      
    }

    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String string) {
        return null;        
    }

    public List<InjectionCapable> getInjectableResourcesByClass(String string) {
        return null;
    }

    public InjectionInfo getInjectionInfoByClass(Class clazz) {
        return null;
    }

    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        for (Iterator itr = this.resourceReferences.iterator(); 
            itr.hasNext();) {
	    ResourceReferenceDescriptor rrd = 
                    (ResourceReferenceDescriptor) itr.next();
	    if (rrd.getName().equals(name)) {
		return rrd;   
	    }
        }
        return null;
    }

    public EjbReference getEjbReference(String name) {
        for (Iterator itr = this.ejbReferences.iterator(); 
            itr.hasNext();) {
	    EjbReference ejbRef = 
                    (EjbReference) itr.next();
	    if (ejbRef.getName().equals(name)) {
		return ejbRef;   
	    }
        }       
        return null;
    }

    public void notification(NotificationEvent notificationEvent){
        
    
    }

    public ClassLoader getModuleClassLoader() {
        // Do we need to return something here ?
        return null;
    }
    
    /**
     * @return the SipBundleDescriptor of which this is a member
     */
    public Object getReferringDescriptor() {
        return referringDescriptor;
    }
    
    /**
     * @param the SipBundleDescriptor of which this is a member
     */    
    public void setReferringDescriptor(SipBundleDescriptor sbd) {
        referringDescriptor = sbd;
    }
    
    /**
     * @return the module descriptor object of the parent SipBundleDescriptor
     */
    public ModuleDescriptor getModuleDescriptor() {
        return this.referringDescriptor.getModuleDescriptor();
    }
    
    public void visit(ComponentVisitor aVisitor) {
        //super.visit(aVisitor);
        //aVisitor.accept(this);
       //((ApplicationValidator)aVisitor).accept(this.getApplication());

        for (Iterator itr = getEjbReferenceDescriptors().iterator();itr.hasNext();) {
            EjbReference aRef = (EjbReference) itr.next();
            aVisitor.accept(aRef);
        }
        for (Iterator itr=getResourceReferenceDescriptors().iterator();
             itr.hasNext();) {
            ResourceReferenceDescriptor next = 
                (ResourceReferenceDescriptor) itr.next();
            aVisitor.accept(next);
        }
        for (Iterator itr=getJmsDestinationReferenceDescriptors().iterator();
             itr.hasNext();) {
            JmsDestinationReferenceDescriptor next = 
                (JmsDestinationReferenceDescriptor) itr.next();
            aVisitor.accept(next);
        }
        
    }    
    
    /**
     * setter method for the sun-sip.xml object
     * @param sunSipApp the sun-sip.xml object
     */
    public void setSunSipDescriptor(SunSipApp sunSipApp) {
        this.sunSipApp = sunSipApp;
    }

    /**
     * getter method for sun-sip.xml object
     * @return sunSipApp the sun-sip.xml object
     */
    public SunSipApp getSunSipDescriptor() {
        if(this.sunSipApp == null) {
            this.sunSipApp = new SunSipApp();
        }
        return this.sunSipApp;
    }
    
    
    public void addAnnotatedServlets( String servletName, Servlet servlet) {
        annotatedServlets.put(servletName, servlet);
    }

    public Map<String, Servlet> getAnnotatedServlets() {
        return annotatedServlets;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}
