/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.deployment.node.sip;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.node.LocalizedNode;
import java.util.Map;
import java.util.Enumeration;
import java.util.logging.Level;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.RunAsNode;
import com.sun.enterprise.deployment.node.SecurityRoleRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.InitParamNode;
import com.sun.enterprise.deployment.xml.WebTagNames;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.InitializationParameter;

import com.sun.enterprise.deployment.util.DOLUtils;

import org.jvnet.glassfish.comms.deployment.backend.SipApplication;
import org.jvnet.glassfish.comms.deployment.util.SipTagNames;

/**
 * This node is responsible for handling the servlet xml sub tree
 *
 * @author  Prasad Subramanian
 * @version 
 */
public class LocalizedInfoNode extends LocalizedNode {

   
    /** Creates new ServletNode */
    public LocalizedInfoNode() {
        super();

    }
  
   /**
    * @return the descriptor instance to associate with this XMLNode
    */
    public Object getDescriptor() {
        return null;
    }   
    
    /**
     * notification of the end of XML parsing for this node
     */
    public void postParsing() {
        Object o = getParentNode().getDescriptor();
        if (o instanceof SipApplication) {
            Descriptor descriptor = (Descriptor) o;
            if (getXMLRootTag().getQName().equals(SipTagNames.DESCRIPTION)) {
                ((SipApplication)descriptor).setDescription(localizedValue);
            }
        } else if (o instanceof EjbReferenceDescriptor ) {
            Descriptor descriptor = (Descriptor) o;
            if(getXMLRootTag().getQName().equals(SipTagNames.DESCRIPTION)) {
                ((EjbReferenceDescriptor)descriptor).setDescription(localizedValue);
            }
        }
    }     
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        table.put(SipTagNames.DISPLAY_NAME, "setDisplayName");
        table.put(SipTagNames.DESCRIPTION, "setDescription");
        table.put(SipTagNames.APP_NAME, "setAppName");        
        table.put(WebTagNames.LISTENER_CLASS, "addListener"); 
        
        return table;
    }        

    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */    
    public void setElementValue(XMLElement element, String value) {    
        if (SipTagNames.DISPLAY_NAME.equals(element.getQName())) {
            ((SipApplication)getDescriptor()).setDisplayName(value);
        } else if (WebTagNames.LISTENER.equals(element.getQName())){
            ((SipApplication)getDescriptor()).addListener(value);            
        } else {
            super.setElementValue(element, value);
        }
    }     
    
    /** 
     * receives notification of the end of an XML element by the Parser
     * 
     * @param element the xml tag identification
     * @return true if this node is done processing the XML sub tree
     */
    public boolean endElement(XMLElement element) {
	//DOLUtils.getDefaultLogger().finer("ENDELEMENT : " + "in " + getXMLRootTag() + "  Node, endElement " + element.getQName());
        boolean allDone = element.equals(getXMLRootTag());
        return allDone;
    } 
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
   /* public Node writeDescriptor(Node parent, Servlet descriptor) {    

        Node myNode = super.writeDescriptor(parent, descriptor);
        appendTextChild(myNode, WebTagNames.SERVLET_NAME, descriptor.getServletName());         
        appendTextChild(myNode, WebTagNames.SERVLET_CLASS, descriptor.getWebComponentImplementation());

        // init-param*
        WebBundleNode.addInitParam(myNode, WebTagNames.INIT_PARAM, descriptor.getInitializationParameters());
        
        if (descriptor.getLoadOnStartUp()!=-1) {
            appendTextChild(myNode, WebTagNames.LOAD_ON_STARTUP, String.valueOf(descriptor.getLoadOnStartUp()));
        }
        
        // run-as
        RunAsIdentityDescriptor runAs = descriptor.getRunAsIdentity();
        if (runAs!=null) {
            RunAsNode runAsNode = new RunAsNode();
            runAsNode.writeDescriptor(myNode, WebTagNames.RUNAS_SPECIFIED_IDENTITY, runAs);
        }
        
        // sercurity-role-ref*
        Enumeration roleRefs = descriptor.getSecurityRoleReferences();
        SecurityRoleRefNode roleRefNode = new SecurityRoleRefNode();
        while (roleRefs.hasMoreElements()) {
            roleRefNode.writeDescriptor(myNode, WebTagNames.ROLE_REFERENCE, 
                            (RoleReference) roleRefs.nextElement());            
        }
        
        return myNode;
    } */
}
