/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.deployment.node.sip;

import com.sun.enterprise.deployment.xml.WebTagNames;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;

import java.util.logging.Level;

import org.jvnet.glassfish.comms.deployment.backend.Pattern;
import org.jvnet.glassfish.comms.deployment.backend.AndOperator;
import org.jvnet.glassfish.comms.deployment.backend.OrOperator;
import org.jvnet.glassfish.comms.deployment.backend.NotOperator;
import org.jvnet.glassfish.comms.deployment.util.SipTagNames;


/**
 * This node is responsible for handling servlet-mapping subtree node
 *
 * @author  Prasad Subramanian
 * @version 
 */
public class PatternNode extends DeploymentDescriptorNode {

    private static LocalStringManagerImpl localStrings =
            new LocalStringManagerImpl(PatternNode.class);
    private final static XMLElement tag = 
        new XMLElement(SipTagNames.PATTERN);
    
    protected Object descriptor = null;
    
    public PatternNode(){
        super();
        registerElementHandler(new XMLElement(SipTagNames.AND), 
                AndOperatorNode.class, "setCondition");
        registerElementHandler(new XMLElement(SipTagNames.OR), 
                OrOperatorNode.class, "setCondition"); 
        registerElementHandler(new XMLElement(SipTagNames.NOT), 
                NotOperatorNode.class, "setCondition"); 
        registerElementHandler(new XMLElement(SipTagNames.EQUALS), 
                EqualsOperandNode.class, "addCondition");
        registerElementHandler(new XMLElement(SipTagNames.EXISTS), 
                ExistsOperandNode.class, "addCondition");
        registerElementHandler(new XMLElement(SipTagNames.CONTAINS), 
                ContainsOperandNode.class, "addCondition");
        registerElementHandler(new XMLElement(SipTagNames.SUBDOMAINOF), 
                SubDomainOfOperandNode.class, "addCondition");        
    }
  
    /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */    
    public void addDescriptor(Object  newDescriptor) {       
        if (newDescriptor instanceof AndOperator) {  
            /*if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {            
                DOLUtils.getDefaultLogger().fine("Adding security role ref " + newDescriptor);
            }*/
            ((Pattern)getDescriptor()).addCondition((AndOperator)newDescriptor);
        } else if (newDescriptor instanceof OrOperator) {
            ((Pattern)getDescriptor()).addCondition((OrOperator)newDescriptor);            
        } else if (newDescriptor instanceof NotOperator) {
            ((Pattern)getDescriptor()).addCondition((NotOperator)newDescriptor);
        }
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor==null) {
            descriptor = (Pattern)DescriptorFactory.getDescriptor(getXMLPath());
        }
        return descriptor;
    }
    
    /**
     * @return the XML tag associated with this XMLNode
     */
    protected XMLElement getXMLRootTag() {
        return tag;
    }    
}
