/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * SunSipApp.java
 *
 * Created on Oct 10, 2007, 1:51:03 PM
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.deployment.runtime.sip;

import com.sun.enterprise.deployment.runtime.web.JspConfig;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;

import org.jvnet.glassfish.comms.deployment.backend.Servlet;

/**
 * Represents the sun-sip.xml descriptor
 * @author Prasad Subramanian
 */
public class SunSipApp extends SunWebApp {
    static public final String SECURITY_ROLE_MAPPING = "SecurityRoleMapping"; // NOI18N
    static public final String SESSION_CONFIG = "SessionConfig"; // NOI18N
    static public final String RESOURCE_ENV_REF = "ResourceEnvRef"; // NOI18N
    static public final String RESOURCE_REF = "ResourceRef"; // NOI18N
    static public final String EJB_REF = "EjbRef"; // NOI18N
    static public final String CACHE = "Cache"; // NOI18N
    static public final String CLASS_LOADER = "ClassLoader"; // NOI18N
    static public final String LOCALE_CHARSET_INFO = "LocaleCharsetInfo"; // NOI18N
    static public final String PARAMETER_ENCODING = "ParameterEncoding";
    static public final String FORM_HINT_FIELD = "FormHintField";
    static public final String DEFAULT_CHARSET = "DefaultCharset";
    public static final String IDEMPOTENT_URL_PATTERN = "IdempotentUrlPattern";
    public static final String ERROR_URL = "ErrorUrl";
    public static final String SIP_SERVLET = "SipServlet";

    public SunSipApp() {
        // set default values
        setAttributeValue(CACHE, "MaxEntries", "4096");
        setAttributeValue(CACHE, "TimeoutInSeconds", "30");
        setAttributeValue(CACHE, "Enabled", "false");
    }

    // This attribute is an array, possibly empty
    public void setServlet(int index, Servlet value) {
        //no-op
    }

    //
    public Servlet getSipServlet(int index) {
        return (Servlet)this.getValue(SIP_SERVLET, index);
    }

    // This attribute is an array, possibly empty
    public void setServlet(Servlet[] value) {
        //no-op
    }

    //
    public Servlet[] getSipServlet() {
         return (Servlet[])this.getValues(SIP_SERVLET);
    }

    // Return the number of properties
    public int sizeServlet() {
        return this.size(SIP_SERVLET);
    }

    // Add a new element returning its index in the list
    public int addServlet(Servlet value) {
        return this.addValue(this.SIP_SERVLET, value);
    }

    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeServlet(Servlet value) {
        return this.removeValue(this.SIP_SERVLET, value);
    }

    // This attribute is optional
    public void setJspConfig(JspConfig value) {
        //no-op
    }

    //
    public JspConfig getJspConfig() {
        return null;
    }

    /**
     * Sets the session configuration information from sun-sip.xml.
     *
     * @param value The session configuration information from sun-sip.xml
     */
    public void setSessionConfig(SessionConfig value) {
	setValue(SunWebApp.SESSION_CONFIG, value);
    }
    
    /**
     * Gets the session configuration information from sun-sip.xml.
     *
     * @return The session configuration information from sun-sip.xml
     */
    public SessionConfig getSessionConfig() {
	return (SessionConfig) getValue(SunWebApp.SESSION_CONFIG);
    }

}
