/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.deployment.annotations.factory;

import com.sun.enterprise.deployment.annotation.AnnotationHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessor;
import com.sun.enterprise.deployment.annotation.factory.Factory;
import com.sun.enterprise.deployment.annotation.impl.AnnotationProcessorImpl;

import org.jvnet.glassfish.comms.deployment.annotations.handlers.SipApplicationHandler;
import org.jvnet.glassfish.comms.deployment.annotations.handlers.SipApplicationKeyHandler;
import org.jvnet.glassfish.comms.deployment.annotations.handlers.SipListenerHandler;
import org.jvnet.glassfish.comms.deployment.annotations.handlers.SipServletHandler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;


/**
 *
 * @author lmcpepe a.k.a. PellePedro
 * @since 15-Nov-07
 *
 */
public class SipHandlerFactory extends Factory {
    private static Set<String> annotationClassNames = new HashSet<String>();
    private static ArrayList<AnnotationHandler> sipAnnotationHandlers;
    private static AnnotationProcessorImpl SipAnnotationProcessor = null;

    static {
        sipAnnotationHandlers = new ArrayList<AnnotationHandler>();
        sipAnnotationHandlers.add(new SipApplicationHandler());

        sipAnnotationHandlers.add(new SipServletHandler());
        sipAnnotationHandlers.add(new SipListenerHandler());
        sipAnnotationHandlers.add(new SipApplicationKeyHandler());
    }

    private SipHandlerFactory() {
    }

    public static AnnotationProcessor getAnnotationProcessor() {
        init();

        AnnotationProcessorImpl processor = Factory.getDefaultAnnotationProcessor();
        processor.setDelegate(SipAnnotationProcessor);

        return processor;
    }

    public static Set<String> getAnnotations() {
        init();

        return (HashSet<String>) ((HashSet) annotationClassNames).clone();
    }

    public static AnnotationProcessor getSystemAnnotationProcessor() {
        return SipAnnotationProcessor;
    }

    private static synchronized void init() {
        if (SipAnnotationProcessor == null) {
            SipAnnotationProcessor = new AnnotationProcessorImpl();

            AnnotationHandler anHandler;

            for (Iterator<AnnotationHandler> iterator = sipAnnotationHandlers.iterator();
                    iterator.hasNext();
                    annotationClassNames.add((new StringBuilder("L")).append(
                            anHandler.getAnnotationType().getName()
                                         .replace('.', '/')).append(";")
                                                  .toString())) {
                anHandler = iterator.next();
                SipAnnotationProcessor.pushAnnotationHandler(anHandler);
            }
        }
    }
}
