/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*1
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.deployment.annotations.handlers;

import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import java.util.logging.Level;

import org.jvnet.glassfish.comms.deployment.backend.SipApplicationBase;
import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;
import org.jvnet.glassfish.comms.util.LogUtil;

import org.jvnet.glassfish.comms.deployment.backend.SipApplication;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;

/**
 * 
 * @author lmcpepe a.k.a. PellePedro
 * @since 15-Nov-07
 *
 */
public abstract class AbstractSipAnnotationHandler extends AbstractHandler {

	protected static Logger theirLog = LogUtil.SIP_LOGGER.getLogger();
	protected static final String LOGPREFIX = 
		"org.jvnet.glassfish.comms.deployment.annotations.handlers. ";

	
    /**
     * Process Annotation with given ResourceContainerContexts.
     * @param ainfo
     * @param rcContexts
     */
    protected abstract HandlerProcessingResult processAnnotation(
    		SipApplication sipApplication,
            AnnotationInfo ainfo,
            ResourceContainerContext[] rcContexts )
            throws AnnotationProcessorException;

    /**
     * Process a particular annotation which type is the same as the
     * one returned by @see getAnnotationType(). All information
     * pertinent to the annotation and its context is encapsulated
     * in the passed AnnotationInfo instance.
     *
     * @param ainfo the annotation information
     */
    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo)
            throws AnnotationProcessorException {

        AnnotatedElementHandler aeHandler = ainfo.getProcessingContext().getHandler();

        // Validation Condition =================================
        
        // WebBundleContext is a ResourceContainerContext.
        if ( (aeHandler == null) ||  !( aeHandler instanceof WebBundleContext)  ) 
        {
    		theirLog.log(Level.SEVERE, LOGPREFIX + "getProcessingContext().getHandler() is not a WebBundleContext");
            return getInvalidAnnotatedElementHandlerResult(
                ainfo.getProcessingContext().getHandler(), ainfo);
        }
        
        WebBundleContext wbc = (WebBundleContext) aeHandler;
        WebBundleDescriptor descrptor = wbc.getDescriptor();
        
        if ( !( descrptor instanceof SipBundleDescriptor) )
        {
        	theirLog.log(Level.SEVERE, LOGPREFIX + "webBundleContext.getDescriptor() is not a SipBundleDescriptor");
            return getDefaultFailedResult();
        }
        
    	SipBundleDescriptor sipBundleDescriptor = (SipBundleDescriptor) descrptor;
    	SipApplication sipApplication = sipBundleDescriptor.getSipApplication();
    	if ( sipApplication == null )
    	{
    		return getDefaultFailedResult();
    	}

    	// End Validation Condition =================================
    	
    	
        ResourceContainerContext[] rcContexts = null;

        rcContexts = new ResourceContainerContext[] { (ResourceContainerContext)aeHandler };

        return processAnnotation((SipApplication)sipApplication,
                                               ainfo, rcContexts);
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return null;
    }
}
