/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.deployment.annotations.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.logging.Level;

import javax.servlet.sip.annotation.SipServlet;

import org.jvnet.glassfish.comms.deployment.backend.Servlet;
import org.jvnet.glassfish.comms.deployment.backend.SipApplication;

import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;

/**
 * 
 * @author Per Pettersson  (pellepedro)
 * @since 15-Nov-07
 *
 */
public class SipServletHandler extends AbstractSipAnnotationHandler 
{

	@Override
	protected HandlerProcessingResult processAnnotation(
			SipApplication sipApplication, 
			AnnotationInfo ainfo,
			ResourceContainerContext[] rcContexts)
			throws AnnotationProcessorException
	{
        AnnotatedElement annotatedElement = ainfo.getAnnotatedElement();
        
        Annotation [] annotation = annotatedElement.getAnnotations();
        for (int i = 0; i < annotation.length; i++) 
        {
        	Class annotationClass = annotation[i].annotationType();
        	if ( annotationClass == getAnnotationType() )
        	{
        		String servletClassName = ((Class)annotatedElement).getName();
        		String packageName = ((Class)annotatedElement).getPackage().getName();

        		String servletName = ((Class)annotatedElement).getSimpleName();


        		Servlet servlet = new Servlet();
        		servlet.setServletClass(servletClassName);
        		
        		// ---- Set load on startup ---
        		SipServlet sipServlet = (SipServlet) ainfo.getAnnotation();
        		
        		int loadOnStartUp = sipServlet.loadOnStartup();
        		servlet.setLoadOnStartup(loadOnStartUp);
        		
        		// --- Set Servlet Name ---
        		// if the annotated Servlet Name is omitted, the the Class Name of the
        		// SipServlet is used as Servlet Name.
        		String annotatedServletName = sipServlet.name();
        		if ( "".equals(annotatedServletName) )
        		{
        			// Servlet Name not annotated
        			annotatedServletName = servletName;
        		}
        		
        		servlet.setServletName(annotatedServletName);
        		servlet.setPackageName(packageName);
        		
        		// --- Set Application Name ---
        		String annotatedAppliationName = sipServlet.applicationName();
        		servlet.setApplicationName(annotatedAppliationName);
        		
        		// Since we are not guaranteed that SipApplication annotation is processed  
        		// before SipServlet, we add the SipServlet to a temporary Map in the
        		// SipApplication structure.
        		
        		sipApplication.addAnnotatedServlets(annotatedServletName, servlet);
        		
        		if (theirLog.isLoggable(Level.INFO)) {
        			theirLog.log(Level.INFO, LOGPREFIX + "SipServlet Annotation : Servlet Class[" + servletClassName +
        					 "] ServletName ["+ annotatedServletName +"]");
        		}

        	}
        }
        return getDefaultProcessedResult();
	}

	public Class<? extends Annotation> getAnnotationType() 
	{
		return javax.servlet.sip.annotation.SipServlet.class;
	}

}
