/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/ 

package org.jvnet.glassfish.comms.deployment.annotations.scanners;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.jvnet.glassfish.comms.deployment.annotations.factory.SipHandlerFactory;

import com.sun.enterprise.deployment.annotation.factory.SJSASFactory;
import com.sun.enterprise.deployment.annotation.impl.AnnotationProcessorImpl;
import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.CustomAnnotationScanner;

/**
 * 
 * @author lmcpepe a.k.a. PellePedro
 * @since 15-Nov-07
 *
 */
public class SipAnnotationScanner implements CustomAnnotationScanner
{

    private static Set<String> annotations=null;

    
    /** Creates a new instance of AnnotationScanner */
    public SipAnnotationScanner() 
    {
    }
        
    /**
     * Test if the passed constant pool string is a reference to 
     * a Type.TYPE annotation of a J2EE component
     *
     * @String the constant pool info string 
     * @return true if it is a J2EE annotation reference
     */
    public boolean isAnnotation(String value) 
    {
        if (annotations==null) 
        {
            synchronized(SipAnnotationScanner.class) 
            {
                if (annotations==null)
                   init();
            }
        }
        return annotations.contains(value);
    }
    
    private void init() 
    {
    	annotations = new HashSet<String>();
    	Set<String> sipAnnotations = SipHandlerFactory.getAnnotations();
    	for (Iterator iterator = sipAnnotations.iterator(); iterator.hasNext();) 
    	{
			String name = (String) iterator.next();
			annotations.add(name);
		}
    }
}
