package org.jvnet.glassfish.comms.deployment.backend;

import com.sun.enterprise.deployment.util.ComponentValidator;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.enterprise.deploy.shared.ModuleType;

import org.jvnet.glassfish.comms.util.LogUtil;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;

public class ArArchiveDescriptor extends BundleDescriptor 
	implements ArchiveDescriptor {

	private static final long serialVersionUID = 7207865173970175303L;
	private ClassLoader itsLoader = null;
	private String itsRouterClassName = null;
        private String moduleName = null;
	
	private static Logger theirLog = LogUtil.SIP_LOGGER.getLogger();
	private static final String LOGPREFIX = 
		"org.jvnet.glassfish.comms.deployment.backend.ArArchiveDescriptor.";
	
	
	public ClassLoader getModuleClassLoader() {
		if (itsLoader == null){
			theirLog.log(Level.WARNING, LOGPREFIX + "classloader_not_set");
			itsLoader = new URLClassLoader(null);
		}
		return itsLoader;
	}
	
	void setModuleClassLoader(ClassLoader aLoader){
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(Level.FINEST, LOGPREFIX + "classloader_set", aLoader);
		}
		itsLoader = aLoader;
	}

	@Override
	public ModuleType getModuleType() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Set getServiceReferenceDescriptors() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getDefaultSpecVersion() {
		// TODO what should be returned here?
		return "1.0";
	}
	
	public void setApplicationRouterClass(String aClassName){
		itsRouterClassName = aClassName;
	}
	
	public String getApplicationRouterClass(){
		return itsRouterClassName;
	}
        
        public String getModuleName() {
            return moduleName;
        } 
        
        public Object getReferringDescriptor() {
            return null;
        }
        
        public void visit(ComponentVisitor o ){
        
        }
	
}
