/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

/*
 * SipArchiveDeployer.java
 *
 * This class is an implementation of the ArchiveDeployer intereface and
 * extends the WebArchiveDeployer. The main function of this class is to
 * handle the processing of a SIP/Converged HTTP+SIP archive by
 * 1. expanding the archive
 * 2. Processing the SIP Deployment descriptors
 * 3. Processing all the Web Application supported deployment descriptors
 * 4. Adding these processed descriptors in a SipBundleDescriptor
 * In addition this class also supports undeployment and clean up operations
 * for a SIP/Converged HTTP+SIP application
 * Created on February 27, 2007, 3:10 PM
 *
 */
package org.jvnet.glassfish.comms.deployment.backend;

import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

import javax.enterprise.deploy.shared.ModuleType;

import org.xml.sax.SAXParseException;

import org.jvnet.glassfish.comms.deployment.backend.SipApplicationBase;

import com.ericsson.ssa.dd.SipParser;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.DeploymentException;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessor;
import com.sun.enterprise.deployment.annotation.ProcessingContext;
import com.sun.enterprise.deployment.annotation.factory.AnnotatedElementHandlerFactory;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.WebArchiveDeployer;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDeployer;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.WebRuntimeDDFile;
import com.sun.enterprise.deployment.pluggable.PluggableDeploymentInfo;
import com.sun.enterprise.deployment.util.DOLLoadingContextFactory;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.util.i18n.StringManager;

import org.xml.sax.SAXParseException;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.enterprise.deploy.shared.ModuleType;

import org.jvnet.glassfish.comms.deployment.backend.SipApplication;
import org.jvnet.glassfish.comms.deployment.annotations.factory.SipHandlerFactory;
import org.jvnet.glassfish.comms.deployment.annotations.scanners.SarScanner;
import org.jvnet.glassfish.comms.deployment.io.runtime.SipRuntimeDDFile;
import org.jvnet.glassfish.comms.deployment.io.SipDeploymentDescriptorFile;

/**
 *
 * @author Prasad Subramanian
 */
public class SipArchiveDeployer extends WebArchiveDeployer
    implements ArchiveDeployer {
    // Member variables
    /* Private variables */
    private String SIP_JAR_ENTRY = "WEB-INF/sip.xml";
    private String WEB_JAR_ENTRY = "WEB-INF" + File.separator + "web.xml";
    private String SIP_DD_ENTRY = "WEB-INF" + File.separator + "sip.xml";
    private String WAR_LIB_DIR = "WEB-INF" + File.separator + "lib";
    private String WAR_CLASSES_DIR = "WEB-INF" + File.separator + "classes";
    private String GENERATED_XML_MODULE_DIR = "xml" + File.separator +
        "j2ee-modules";
    private String GENERATED_XML_APP_DIR = "xml" + File.separator +
        "j2ee-apps";
    private ModuleType moduleType = XModuleType.getModuleType(this.getClass()
                                                                  .getName());
    private boolean isJ2eeApplication = false;

    /* Protected variables */
    protected SipBundleDescriptor sbd = null;
    protected DeploymentDescriptorFile standardDD = new WebDeploymentDescriptorFile();
    protected ClassLoader classLoader = null;

    //protected ExtensionModuleConfigManager emConfigMgr = null;
    // need this for representing the BundleDescriptor
    protected WebBundleDescriptor descriptor = null;

    //Public methods
    public boolean load(ArchiveDescriptor descriptor) {
        return true;
    }

    public boolean unload(ArchiveDescriptor descriptor) {
        return true;
    }

    /**
     * This method does the following
     * a. Parse the sip.xml
     * b. Process the web related bundle descriptors
     * c. add the web bundle descriptor to SipBundleDescriptor
     * d. During startup of the Application server reads the deployment
     *    except sip.xml from the generated folder.
     * e. Process annotations defined by the SIP Servlet API (code to be added)
     *
     * @param moduleRootDirectory the directory where the archive is exploded
     * @param moduleScratchDirectory the directory where the generated artifacts     *                               are stored
     * @param parentClassLoader the parent class loader for this application
     * @param isStartup a boolean that indicates if this is a deployment time
     *                  operation or startup time
     */
    public ArchiveDescriptor prepare(File moduleRootDirectory,
        File moduleScratchDirectory, ClassLoader parentClassLoader,
        boolean isStartup) throws Exception {
        String moduleDir = moduleRootDirectory.getAbsolutePath();
        String moduleName = moduleDir.substring(moduleDir.lastIndexOf("/") + 1,
                moduleDir.length());

        // This is the initial moduleDir 
        // sailfin/domains/domain1/applications/j2ee-apps/DeployTest/DeployTest-war_war
        
        // This is the moduleDir at reDeployment
        // sailfin/domains/domain1/generated/xml/j2ee-apps/DeployTest/DeployTest-war_war
        
        String sarScanDir = moduleDir;
        
        try {
            if ( moduleDir.indexOf("generated") >= 0 && moduleDir.indexOf("xml") >= 0 ) {
                if (getJ2eeApplication()) {
                    //
                    String earName = moduleRootDirectory.getParentFile().getName();
                    String appType = moduleRootDirectory.getParentFile().getParentFile().getName();
                    File domainDir = moduleRootDirectory.getParentFile().getParentFile().
                    getParentFile().getParentFile().getParentFile();
                    File scanDir = new File ( domainDir, "applications" + File.separatorChar +
                            appType + File.separatorChar + earName + 
                            File.separatorChar + moduleRootDirectory.getName());
                    sarScanDir = scanDir.getAbsolutePath();
                } else {
                    // 
                    String appType = moduleRootDirectory.getParentFile().getName();
                    File domainDir = moduleRootDirectory.getParentFile().getParentFile().
                    getParentFile().getParentFile();
                    File scanDir = new File ( domainDir, "applications" +
                            File.separatorChar +  appType + 
                            File.separatorChar + moduleRootDirectory.getName());
                    sarScanDir = scanDir.getAbsolutePath();          
                }
            }
        } catch (NullPointerException e) {
            logger.log(Level.WARNING, e.toString());
        }

        //parse the web and SIP DDs
        sbd = new SipBundleDescriptor();

        Application application = null;
        WebBundleDescriptor wbd = null;

        // check if this is a converged app. The rule is the presence of a 
        // web.xml
        if (hasWebXML(moduleRootDirectory, WEB_JAR_ENTRY)) {
            setConverged(true);
        } else {
            setConverged(false);
        }


        // now check is this a sub-module of an Enterprise Application
        if (getJ2eeApplication()) {
            // we know that its a sub-module in a EAR
            wbd = (WebBundleDescriptor) getBundleDescriptor(moduleDir,
                    parentClassLoader);

            //((SipBundleDescriptor)wbd).setConverged(isConverged());
        } else if (!isStartup && (moduleDir.indexOf("nodeagents") < 0)) {
            // deployment operation 
            //set the module type to be WAR
            this.setModuleType(ModuleType.WAR);
            processWebArchive();
            application = getApplication();
            //set the module type back to the archive deployer type
            this.setModuleType(XModuleType.getModuleType(
                    this.getClass().getName()));

            if (application != null) {
                wbd = (WebBundleDescriptor) application.getStandaloneBundleDescriptor();
            }
        } else {
            //this.setModuleType(ModuleType.WAR);

            // loading application during AS startup
            // Obtain the application object
            application = getApplication(moduleName, moduleRootDirectory,
                    moduleScratchDirectory, moduleType);

            //set the module type back to the archive deployer type
            //this.setModuleType(XModuleType.getModuleType(
            //                    this.getClass().getName()));            
            if (application != null) {
                wbd = (WebBundleDescriptor) application.getStandaloneBundleDescriptor();
            }
        }

        if (wbd != null) {
            sbd.copyWebBundleDescriptor(wbd);
            sbd.setApplication(application);
        }

        //parse sip.xml now
        /*SipApplication sipApplication = SipParser.parse(getSipXml(
                    moduleRootDirectory, SIP_DD_ENTRY));
        */
        readSipDeploymentDescriptors(moduleRootDirectory, sbd);
        // set the module name
        sbd.getSipApplication().setModuleName(moduleName);
        //set the Referring Decsriptor
        sbd.getSipApplication().setReferringDescriptor(sbd);
        sbd.setConverged(isConverged());
        

        // Now process the runtime DDs
        readRuntimeDeploymentDescriptors(moduleRootDirectory, sbd);
        if(!isStartup && (moduleDir.indexOf("nodeagents") < 0) ) {
           //runSipVerifier();
        }
        
        //Create an Annotation processor here 
        try {
            AnnotatedElementHandler aeHandler =
                AnnotatedElementHandlerFactory.createAnnotatedElementHandler(sbd);
			SarScanner scanner = new SarScanner();
			scanner.initScanRepository(new File(sarScanDir), (WebBundleDescriptor)sbd);
			
	        if (!scanner.getElements().isEmpty()) {
	        	AnnotationProcessor ap = SipHandlerFactory.getAnnotationProcessor();
	            ProcessingContext ctx = ap.createContext();

	            ctx.setProcessingInput(scanner);
	            ctx.pushHandler(aeHandler);
	            ap.process(ctx);
	            postProcessAnnotations();
	        }
	        
        } catch (Exception ioe) {
            ioe.printStackTrace();
	    logger.log(Level.SEVERE, ioe.toString());
        }
        
        return sbd;
    }

    private void postProcessAnnotations() throws Exception {

        // Rules for adding annotated SipServlets

        // 1. If only one annotated SipServlet exists, then the SipApplication
        // annotation is optional.
        // Otherwise a logging error

        SipApplication sipApplication = (SipApplication) sbd
                .getSipApplication();
        
        String ApplicationName = sipApplication.getAppName();
        String mainServletName = sipApplication.getMainservletName();

        Map<String, Servlet> annotatedServlets = sipApplication.getAnnotatedServlets();

        // Find the number of annotated servlets
        int noAnnotatedServlets = annotatedServlets.size();

        // Find the number of servlets defined in the DD.
        int declarativeDefinedServlets = sipApplication.getServlets().size();

        // If multiple annotated servlets exists, then a main servlet has to be
        // defined in the SipApplication annotation.

        if (mainServletName == null && noAnnotatedServlets > 1) {
            logger.log(Level.SEVERE,
                            "No main servlet defined in a SAR archive " +
                            "with multiple annotated servlets");
            throw new DeploymentException(
                    "No main servlet defined in a SAR archive " +
                    "with multiple annotated servlets");
        } 
        
        
        

        for (String servletName : annotatedServlets.keySet()) {
            Servlet servlet = annotatedServlets.get(servletName);

            // Check that the servlet belongs to the same application, by bening
            // defined in same package

            // Check that this servlet name is not defined in sip.xml
            // then ignore it.
            Map<String, Servlet> servlets = sipApplication.getServlets();
            Map<String, ServletMapping> servletMappings = sipApplication
                    .getServletMappings();

            // Servlets defined in sip.xml overrides annotations
            if (servlets.get(servletName) != null) {
                // Servlet specified in sip.xml
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO,
                            "Annotated servlet found with same name "
                                    + "as servlet defined in sip.xml name = "
                                    + servletName);
                    logger.log(Level.INFO, "Annotated servlet discarded");
                }
                continue;
            }

            /*
             * Check that the Servlet belongs to the same Application, That is
             * 1. Same Package as the package-info.java package annotation, or
             * 2. Same Application Name
             * 
             */
            
            String packageInfoPackage = sipApplication.getPackageName();
            String servletPackage = servlet.getPackageName();
            
            @SuppressWarnings("unused")
            boolean servletPartOfApplication = true; // used for readabilty only
            
            String anotatedServletApplication = servlet.getApplicationName();
            
            // If there is only one annotated servlet, we don't require 
            // SipApplication annotation to be present
            
            if ( noAnnotatedServlets == 1 ) {
                servletPartOfApplication = true;
            } 
            else if ( !"".equals(anotatedServletApplication) && 
                    anotatedServletApplication.equals(sipApplication.getAppName()) ) {
                // Same Application
                servletPartOfApplication = true;
                
            } else if ( packageInfoPackage!= null && 
                        servletPackage != null && 
                        servletPackage.equals(packageInfoPackage) ) {
                // same package as package-info.java annotation
                servletPartOfApplication = true;
                
            } else {
                // Not in same application, discharge his servlet
                
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO,
                            "Annotated servlet found " + servletName +
                            " Servlet not defined as part of Sip Application " +
                            "and discharged");
                }
                continue;
            }
            

            ExistsOperand existsOperand = new ExistsOperand();

            // If only one annotated servlet exist, this is regarded as main
            // servlet
            if (servletName.equals(mainServletName) || noAnnotatedServlets == 1) {
                // Create a match all Pattern
                existsOperand.setVariable("request.method");
            } else {
                // Create a match nothing Pattern
                // This is not part of Operand.getAttributeValue()
                existsOperand.setVariable("NeverMatchMe");
            }


            Pattern pattern = new Pattern();
            pattern.addCondition(existsOperand);

            ServletMapping servletMapping = new ServletMapping();
            servletMapping.setServletName(servletName);
            servletMapping.setPattern(pattern);
            
            sipApplication.addServlet(servlet);
            sipApplication.addServletMapping(servletMapping);
           
        }
    }

	/**
     * Expands the archive to be deployed. Delegates to the super class.
     * @param archivePath the path to the archive
     * @param moduleRootDirectory the directory where the contents of the
     *                            archive would need to be copied after
     *                            exploded
     */
    public void expand(File archivePath, File moduleRootDirectory)
        throws Exception {
        super.expand(archivePath, moduleRootDirectory);
    }

    /**
     * Determines if this is the correct ArchiveDeployer to process this archive
     * @param archive the archive being processed
     * @return boolean true if this the ArchiveDeployer implementation to
     *                 process this archive
     */
    public boolean handles(AbstractArchive archive) {
        // Need to check the case when there is no sip.xml   
        return hasSipXML(archive);
    }

    /**
     * Main method that deals with undeployment of the SIP/Converged Applications
     * @param archive the location of the archive that is being undeployed
     */
    public void cleanup(File archive) {
        //set the module type to be WAR
        this.setModuleType(ModuleType.WAR);
        processWebArchive();
        cleanup_internal();
        //set the module type back to the archive deployer type
        this.setModuleType(XModuleType.getModuleType(this.getClass().getName()));
    }

    /**
     * Method that returns a description for this extension module
     * @return the description for this module
     */
    public String getModuleDescription() {
        return "SIP Application";
    }

    /**
     * Method that returns the standard deployment descriptor
     * @return the class that represents a standard deployment descriptor
     *          file
     */
    public DeploymentDescriptorFile getStandardDDFile() {
        return standardDD;
    }

    /**
     * Returns the runtime deployment descriptor sun-web.xml in this case
     * @return the class that represenst the runtime web descriptor
     */
    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new WebRuntimeDDFile();
    }

    /**
     * Returns the default web.xml representation
     * @return the class the represents the default-web.xml
     */
    public Descriptor getDefaultBundleDescriptor() {
        WebBundleDescriptor webBundleDesc = DOLLoadingContextFactory.getDefaultWebBundleDescriptor();

        return webBundleDesc;
    }

    protected boolean hasWebXML(File moduleRootDirectory, String WEB_JAR_ENTRY) {
        try {
            File webXML = new File(moduleRootDirectory, WEB_JAR_ENTRY);

            if (!webXML.exists()) {
                return false;
            }

            FileInputStream fis = new FileInputStream(webXML);

            if (fis.read() > 0) {
                fis.close();

                return true;
            } else {
                fis.close();

                return false;
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
            logger.log(Level.SEVERE, ioe.toString());

            return false;
        }
    }

    /**
     * This method checks if the archive being processed has a WEB-INF/sip.xml
     * or not. This is used to deteremine if this class can process this archive     * or not
     * @return true if there is a WEB-INF/sip.xml in the archive
     */
    protected boolean hasSipXML(AbstractArchive archive) {
        InputStream is = null;
        try {
            is = archive.getEntry(SIP_JAR_ENTRY);
            if (is != null) {
                return true;
            } else {
                return false;
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
            logger.log(Level.SEVERE, ioe.toString());
            return false;
        } finally {
            try {
                if(is != null) is.close();
            } catch (IOException ioexception) {
                
            }
        }
    }

    /**
     * This method reads the sip.xml contents into a byteArryInputStream. This
     * method tries to replicate what the ServletContext.getResourceAsStream
     * does
     *
     * @param moduleRootDirectory the directory where the module is exploded
     * @param sipXmlPath the path to the sip.xml with the application
     * @return InputStream
     */
    protected InputStream getSipXml(File moduleRootDirectory, String sipXmlPath) {
        File sipXmlFile = new File(moduleRootDirectory, sipXmlPath);

        try {
            // create a FileInputStream
            FileInputStream fis = new FileInputStream(sipXmlFile);
            byte[] sipXmlBytes = new byte[(int) sipXmlFile.length()];

            // read the file into the byte array
            int offset = 0;
            int numRead = 0;

            while ((offset < sipXmlBytes.length) &&
                    ((numRead = fis.read(sipXmlBytes, offset,
                            sipXmlBytes.length - offset)) >= 0)) {
                offset = +numRead;
            }

            // now create a ByteArrayInputStream
            return new ByteArrayInputStream(sipXmlBytes);
        } catch (FileNotFoundException fnfe) {
            System.out.println("FileNotFoundException thrown");
            fnfe.printStackTrace();
        } catch (IOException ioe) {
            System.out.println("IOException thrown ");
            ioe.printStackTrace();
        }

        return null;
    }

    /**
     * Returns the moduleType of the application being processed
     * @return the ModuleType object that represents the module type of the
     *         application being processed
     */
    public ModuleType getModuleType() {
        return moduleType;
    }

    /**
     * Sets the module type for the application being processed
     * @param mType the ModuleType object representing the module type
     */
    public void setModuleType(ModuleType mType) {
        moduleType = mType;
    }

    public void setDescriptor(Descriptor descriptor) {
        if (descriptor instanceof WebBundleDescriptor) {
            this.descriptor = (WebBundleDescriptor) descriptor;
        } else {
            if (descriptor instanceof Application) {
                // this is acceptable if the application actually represents 
                // a standalone module
                java.util.Set webBundles = ((Application) descriptor).getWebBundleDescriptors();

                if (webBundles.size() > 0) {
                    this.descriptor = (WebBundleDescriptor) webBundles.iterator()
                                                                      .next();

                    if (this.descriptor.getModuleDescriptor().isStandalone()) {
                        return;
                    } else {
                        this.descriptor = null;
                    }
                }
            }

            throw new RuntimeException("Error setting descriptor " +
                descriptor + " in " + this);
        }
    }

    /**
     * Returns the descriptor object for the module being processed
     * @return the descriptor object for the module being processed
     */
    public BundleDescriptor getDescriptor() {
        return descriptor;
    }

    public void readRuntimeDeploymentDescriptors(File moduleRootDirectory,
        SipBundleDescriptor sbd) {
        
        FileArchive archive = new FileArchive();

        try {
            archive.open(moduleRootDirectory.getAbsolutePath());
        } catch (IOException io) {
            System.out.println("IOException thrown : Error opening module");
            io.printStackTrace();
        }

        String ddFileEntryName = getRuntimeDeploymentDescriptorPath();

        if (ddFileEntryName == null) {
            return;
        }

        InputStream is = null;

        try {
            // apply the runtime settings if any
            is = archive.getEntry(ddFileEntryName);

            DeploymentDescriptorFile confDD = new SipRuntimeDDFile();

            if (archive.getArchiveUri() != null) {
                confDD.setErrorReportingString(archive.getArchiveUri());
            }

            if ((is != null) && (confDD != null)) {
                confDD.setXMLValidation(super.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(super.getRuntimeXMLValidationLevel());
                confDD.read(sbd, is);
            }
        } catch (SAXParseException spe) {
            System.out.println(
                "SAXParseException:Error reading the sun-sip.xml");
            spe.printStackTrace();
        } catch (IOException ioe) {
            System.out.println("IOException:Error reading the sun-sip.xml");
            ioe.printStackTrace();
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException ioe) {
                }
            }
        }
    }

    public String getRuntimeDeploymentDescriptorPath() {
        return new SipRuntimeDDFile().getDeploymentDescriptorPath();
    }

    @Override
    public void runVerifier() throws IASDeploymentException {
        /** 
         * Verification process should be deferred until the
         * SipApplication is available. Hence, deliberate NO-OP here.
         */
    }
    
    private void runSipVerifier() throws Exception {
        /** 
         * Set sbd in the ModuleDescriptor so that 
         * application.getModules().next() returns the newly created
         * SipModule instead of WebModule.
         */
        BundleDescriptor prev = sbd.getModuleDescriptor().getDescriptor();
        sbd.getModuleDescriptor().setDescriptor(sbd);
        super.runVerifier();
        sbd.getModuleDescriptor().setDescriptor(prev);
    }
    
    /**
     * Method to read the sip.xml in an archive and add a SipApplication  object
     * to the SipBundledescriptor passed in
     * @param moduleRootDirectory the path where the archive is exploded
     * @param sbd the SipBundleDescriptor object for the entire bundle
     */
    public void readSipDeploymentDescriptors(File moduleRootDirectory,
        SipBundleDescriptor sbd) throws Exception {
        
        FileArchive archive = new FileArchive();

        try {
            archive.open(moduleRootDirectory.getAbsolutePath());
        } catch (IOException io) {
            System.out.println("IOException thrown : Error opening module");
            io.printStackTrace();
        }

        String ddFileEntryName = getSipDeploymentDescriptorPath();

        if (ddFileEntryName == null) {
            return;
        }

        InputStream is = null;

        try {
            // apply the runtime settings if any
            is = archive.getEntry(ddFileEntryName);

            DeploymentDescriptorFile confDD = new SipDeploymentDescriptorFile();

            if (archive.getArchiveUri() != null) {
                confDD.setErrorReportingString(archive.getArchiveUri());
            }

            if ((is != null) && (confDD != null)) {
                confDD.setXMLValidation(super.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(super.getRuntimeXMLValidationLevel());
                confDD.read(sbd, is);
            }
        } catch (SAXParseException spe) {
            System.out.println(
                "SAXParseException:Error reading the sip.xml");
            spe.printStackTrace();
            throw new Exception(spe);
        } catch (IOException ioe) {
            System.out.println("IOException:Error reading the sip.xml");
            ioe.printStackTrace();
            throw new Exception(ioe);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException ioe) {
                }
            }
        }
     }

    /**
     * Method to return the Deployment Descriptor path in a archive
     * @return String the relative path of the DD within the archive
     */
    public String getSipDeploymentDescriptorPath() {
        return new SipDeploymentDescriptorFile().getDeploymentDescriptorPath();
    }    
    
    public void setJ2eeApplication(boolean isJ2ee) {
        this.isJ2eeApplication = isJ2ee;
    }
    
    public boolean getJ2eeApplication() {
        return isJ2eeApplication;
    }
    
}
