/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.DialogManager;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;



public class DialogManagerStatsImpl implements DialogManagerStats, SipStats {
    private MutableCountStatistic failedSipDialogs;
    private MutableCountStatistic concurrentSipDialogs;
    private MutableCountStatistic expiredSipDialogs;
    private MutableCountStatistic successfulSipDialogs;
    private MutableCountStatistic totalSipDialogCount;
    private MutableCountStatistic totalSipDialogLifeTime;
    private DialogManager dialogManager = null;
    private GenericStatsImpl baseStatsImpl;

    public DialogManagerStatsImpl() {
        initializeStatistics();
        baseStatsImpl = new GenericStatsImpl(DialogManagerStats.class, this);
    }

    public void setStatsProvider(Layer provider) {
        this.dialogManager = (DialogManager)provider;
    }

    private void initializeStatistics() {
        CountStatistic c;
        c = new CountStatisticImpl("FailedSipDialogs");
        failedSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("ConcurrentSipDialogs");
        concurrentSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("expiredSipDialogs");
        expiredSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("successfulSipDialogs");
        successfulSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipDialogCount");
        totalSipDialogCount = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipDialogLifeTime");
        totalSipDialogLifeTime = new MutableCountStatisticImpl(c);
    }

    public CountStatistic getFailedSipDialogs() {
        failedSipDialogs.setCount((dialogManager == null) ? 0
                                                           : dialogManager.getEasFailedSipDialogs());

        return (CountStatistic) failedSipDialogs.unmodifiableView();
    }

    public CountStatistic getExpiredSipDialogs() {
        expiredSipDialogs.setCount((dialogManager == null) ? 0
                                                            : dialogManager.getEasExpiredSipDialogs());

        return (CountStatistic) expiredSipDialogs.unmodifiableView();
    }

    public CountStatistic getSuccessfulSipDialogs() {
        successfulSipDialogs.setCount((dialogManager == null) ? 0
                                                               : dialogManager.getEasSuccessfulSipDialogs());

        return (CountStatistic) successfulSipDialogs.unmodifiableView();
    }

    public CountStatistic getTotalSipDialogCount() {
        totalSipDialogCount.setCount((dialogManager == null) ? 0
                                                              : dialogManager.getEasTotalSipDialogCount());

        return (CountStatistic) totalSipDialogCount.unmodifiableView();
    }

    public CountStatistic getTotalSipDialogLifeTime() {
        totalSipDialogLifeTime.setCount((dialogManager == null) ? 0
                                                                 : dialogManager.getEasTotalSipDialogLifeTime());

        return (CountStatistic) totalSipDialogLifeTime.unmodifiableView();
    }

    public CountStatistic getConcurrentSipDialogs() {
        concurrentSipDialogs.setCount((dialogManager == null) ? 0
                                                               : dialogManager.getEasConcurrentSipDialogs());

        return (CountStatistic) concurrentSipDialogs.unmodifiableView();
    }

    public Statistic getStatistic(String name) {
        return baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return baseStatsImpl.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return baseStatsImpl.getStatistics();
    }

    public Class getInterfaceClass() {
        return DialogManagerStats.class;
    }
}
