/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.admin.monitor.registry.spi.extensions;

import com.ericsson.ssa.container.startup.SipMonitoring;
import com.ericsson.ssa.sip.Layer;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.DottedNameFactory;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringObjectNames;
import com.sun.enterprise.admin.monitor.registry.spi.StatsDescriptionHelper;
import com.sun.enterprise.admin.monitor.stats.*;
import com.sun.enterprise.admin.pluggable.MonitoringManager;
import com.sun.enterprise.server.ApplicationServer;
import java.util.List;
import java.util.Iterator;
import java.util.Vector;
import java.util.ResourceBundle;
import org.jvnet.glassfish.comms.admin.monitor.NetworkManagerStatsImpl;
import org.jvnet.glassfish.comms.admin.monitor.OverloadProtectionManagerStatsImpl;
import org.jvnet.glassfish.comms.admin.monitor.DialogManagerStatsImpl;
import org.jvnet.glassfish.comms.admin.monitor.TransactionManagerStatsImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;
import org.jvnet.glassfish.comms.admin.monitor.SipStats;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.MonitoringService;

/**
 * Manager class responsible for registration/unregistration of all the
 *  SIP Stats. In addition, this class is responsible for handling the
 * monitoring level change events pertaining to SIP monitoring
 */
public class SipMonitoringManagerImpl implements MonitoringManager, MonitoringLevelListener {

    private static final String SIP_SERVICE = "sip-service";
    private static final Logger logger = Logger.getLogger(AdminConstants.kLoggerName);
    private static final SipMonitoringManagerImpl smm = new SipMonitoringManagerImpl();
    private static ResourceBundle resourceBundle = null;
    private static final String DEFAULT_PACKAGE = "org.jvnet.glassfish.comms.admin.monitor.registry.spi.extensions";
    private static final String DEFAULT_FILE = "LocalStrings";
    private static final MonitoredObjectType sipNode = MonitoredObjectType.newMonitoredObjectType(SIP_SERVICE, true);
    private static StatsHolder rsHolder = null;
    private static List<String> nodes = new Vector<String>();
    private MonitoringLevel level;
    private boolean registered = false;

    /** Creates a new instance of SipMonitoringManagerImpl */
    public SipMonitoringManagerImpl() {        
        resourceBundle = ResourceBundle.getBundle(DEFAULT_PACKAGE + "." + DEFAULT_FILE);
    }

    public static SipMonitoringManagerImpl getInstance() {
        return smm;
    }

    private static StatsHolder getRootStatsHolder() {
        return rsHolder;
    }

    private final StatsHolder getSipStatsHolder() {
        return getRootStatsHolder().getChild(SIP_SERVICE);
    }

    /**
     * Method that handles the registration of all the
     * stats for various layers of SIP stats
     */
    public void registerAllStats(StatsHolder rootStatsHolder) {        
        rsHolder = rootStatsHolder;
        initializeSipService();

        try {
            StatsDescriptionHelper.getInstance().addResourceBundle(resourceBundle);
            registerSipStats(SipMonitoring.SESSION_MANAGER, new DialogManagerStatsImpl());
            registerSipStats(SipMonitoring.NETWORK_MANAGER, new NetworkManagerStatsImpl());
            registerSipStats(SipMonitoring.TRANSACTION_MANAGER, new TransactionManagerStatsImpl());
            registerSipStats(SipMonitoring.OVERLOAD_PROTECTION_MANAGER, new OverloadProtectionManagerStatsImpl());

            if (shouldRegisterMBeans())
                registerMBeans();

        } catch (MonitoringRegistrationException ex) {
            Logger.getLogger(SipMonitoringManagerImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void initializeSipService() {
        final StatsHolder ssNode = rsHolder.addChild(SIP_SERVICE, sipNode);
        assert (ssNode != null) : "Initialization Error in SipServiceCreation";
        ssNode.setObjectName(MonitoringObjectNames.getMonitoredObjectName(sipNode.getTypeName()));
        ssNode.setDottedName(DottedNameFactory.getDottedName(sipNode.getTypeName()));
        ssNode.registerMBean();
    }

    public boolean isSipServiceInitialized() {
        StatsHolder sips = getRootStatsHolder().getChild(SIP_SERVICE);

        return sips != null;
    }

    public boolean shouldRegisterMBeans() {
        try {
            Config cfg = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext());
            MonitoringService monService = cfg.getMonitoringService();
    
            ElementProperty monLevel =
                monService.getModuleMonitoringLevels().getElementPropertyByName("sip-service");
            if (monLevel != null) {
                String val = monLevel.getValue();
                if (val.equalsIgnoreCase("OFF"))
                    return false;
                else if (val.equalsIgnoreCase("LOW") || val.equalsIgnoreCase("HIGH"))
                    return true;
            }
        } catch (Exception e) {
            return false;
        }
        return false;
    }

    public void registerSipStats(String nodeName, SipStats statsImpl) throws MonitoringRegistrationException {

        if (statsImpl == null) {
            throw new IllegalArgumentException("registerStats  - null stats provided");
        }

        final StatsHolder sips = getSipStatsHolder();
        MonitoredObjectType moType = MonitoredObjectType.newMonitoredObjectType(nodeName, false);
        final StatsHolder moNode = sips.addChild(nodeName, moType);
        assert (moNode != null) : "MRH:registerStats - Initialization failed for " + nodeName;
        moNode.setObjectName(MonitoringObjectNames.getMonitoredObjectName(moType.getTypeName()));
        moNode.setDottedName(DottedNameFactory.getDottedName(moType.getTypeName(), sips.getName()));
        moNode.setStats(statsImpl);
        moNode.setStatsClass(statsImpl.getInterfaceClass());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(nodeName + " stats is registered");
        }
//        moNode.registerMBean();
    }

    public void enableSipStats(String nodeName, Layer provider, MonitoringLevel level) {
        final StatsHolder node = getSipStatsHolder().getChild(nodeName);
        ((SipStats) (node.getStats())).setStatsProvider(provider);
//        if(!registered)
//            registerListener();
        addNode(nodeName);
        if (logger.isLoggable(Level.FINE)) {
            logger.info(nodeName + " stats is connected to " + provider.getClass().getName());
        }
    }

    private void registerLevel(MonitoringLevel level) {
        this.level = level;
        SipMonitoring.setLevel("", level);
    }

    public void addNode(String node) {
        nodes.add(node);
    }

    public void setLevel(MonitoringLevel arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void changeLevel(MonitoringLevel arg0, MonitoringLevel arg1, Stats arg2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void registerListener() {
        MonitoringRegistry monitoringRegistry = ApplicationServer.getServerContext().getMonitoringRegistry();
        monitoringRegistry.registerMonitoringLevelListener(this, sipNode);
        registered = true;
    }

    private void unregisterMBeans() {
        for (String nodeName : nodes) {
            StatsHolder node = getSipStatsHolder().getChild(nodeName);
            node.unregisterMBean();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("removed MBean for " + nodeName);
            }
        }
    }

    private void registerMBeans() {
        Iterator it = getSipStatsHolder().getAllChildren().iterator();
        while (it.hasNext()) {
            StatsHolder c = (StatsHolder) it.next();
            c.registerMBean();
        }
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (to.equals(from)) {
            return;
        }
        if (to.equals(MonitoringLevel.OFF) && !to.equals(level)) {
//                unregisterMBean if registered
            registerLevel(MonitoringLevel.OFF);
            unregisterMBeans();
        } else {
//                registerMBean if unregistered
            if (level.equals(MonitoringLevel.OFF)) {
                registerMBeans();
            }
            registerLevel(to);
        }
    }
}
