/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 * Copyright (c) Ericsson AB, 2004-2008. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.replication.initialization;

import com.ericsson.ssa.config.BaseSipPersistenceStrategyBuilder;
import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.sip.DialogFragmentManager;
import com.ericsson.ssa.sip.SipApplicationSessionStore;
import com.ericsson.ssa.sip.SipSessionStore;

import com.sun.enterprise.config.serverbeans.SipContainerAvailability;
import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.StoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;

import java.util.logging.Level;

import org.apache.catalina.LifecycleException;
import org.jvnet.glassfish.comms.replication.sessmgmt.ServletTimerStoreFactory;
import org.jvnet.glassfish.comms.replication.sessmgmt.ServletTimerStoreImpl;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipApplicationSessionStoreFactory;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipApplicationSessionStoreImpl;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipSessionStoreFactory;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipSessionStoreImpl;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipTransactionPersistentManager;
import org.jvnet.glassfish.comms.replication.dialogmgmt.ReplicationDialogFragmentManager;
import org.jvnet.glassfish.comms.util.LogUtil;

public abstract class SipStrategyBuilder
    extends BaseSipPersistenceStrategyBuilder {

    protected abstract void setSessionFactory(SipTransactionPersistentManager mgr);

    public void initializePersistenceStrategy(ConvergedContext ctx,
        SipContainerAvailability sca) {
        SipTransactionPersistentManager mgr = new SipTransactionPersistentManager();
        mgr.setPassedInPersistenceType(getPassedInPersistenceType());

        initializePersistenceStrategy(mgr, ctx, sca);

        setSessionFactory(mgr);

        mgr.setSipApplicationSessionStore(new SipApplicationSessionStoreImpl());
        mgr.setSipSessionStore(new SipSessionStoreImpl());
        mgr.setServletTimerStore(new ServletTimerStoreImpl());

        /*
         * Add StorePools
         */
        ServerConfigReader configReader = new ServerConfigReader();

        int haStorePoolSize = configReader.getHAStorePoolSizeFromConfig();
        int haStorePoolUpperSize = configReader.getHAStorePoolUpperSizeFromConfig();
        int haStorePoolPollTime = configReader.getHAStorePoolPollTimeFromConfig();

        // SipApplicationSession StorePool        
        StoreFactory sipApplicationSessionStoreFactory = new SipApplicationSessionStoreFactory();
        StorePool sipApplicationSessionStorePool = new StorePool(haStorePoolSize,
                haStorePoolUpperSize, haStorePoolPollTime,
                sipApplicationSessionStoreFactory);
        mgr.setSipApplicationSessionStorePool(sipApplicationSessionStorePool);

        // SipSession StorePool
        StoreFactory sipSessionStoreFactory = new SipSessionStoreFactory();
        StorePool sipSessionStorePool = new StorePool(haStorePoolSize,
                haStorePoolUpperSize, haStorePoolPollTime,
                sipSessionStoreFactory);
        mgr.setSipSessionStorePool(sipSessionStorePool);

        // ServletTimer StorePool
        StoreFactory servletTimerStoreFactory = new ServletTimerStoreFactory();
        StorePool servletTimerStorePool = new StorePool(haStorePoolSize,
                haStorePoolUpperSize, haStorePoolPollTime,
                servletTimerStoreFactory);
        mgr.setServletTimerStorePool(servletTimerStorePool);

        ctx.setSipSessionManager(mgr);

        // If we are doing replication initialize jxta pipes if they
        // haven't been already
        String passedInPersistenceType = getPassedInPersistenceType();
        if (EEPersistenceTypeResolver.REPLICATED_TYPE.equalsIgnoreCase(passedInPersistenceType)) { 
            JxtaReplicationReceiver receiver = JxtaReplicationReceiver.createInstance();
            receiver.doPipeInitialization();
  
            // ensure the Replication DialogFragmentManager service is initialized and started.
            DialogFragmentManager dfm = DialogFragmentManager.getInstance();
            try {
                if (dfm instanceof ReplicationDialogFragmentManager) {
                    ReplicationDialogFragmentManager rdfm = (ReplicationDialogFragmentManager) dfm;
                    rdfm.initializeReplication(passedInPersistenceType, haStorePoolSize, haStorePoolUpperSize, haStorePoolPollTime);
                    rdfm.startReplication();
                }
            } catch (IllegalStateException isex) {
                LogUtil.SSR_LOGGER.getLogger().log(Level.SEVERE, "df_manager_startup_error");
                LogUtil.SSR_LOGGER.getLogger().log(Level.SEVERE, isex.getMessage(), isex);
            }
        } 
    }
}
